/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.model.DetectedDbAttribute;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);
    private final DbAdapter adapter;
    boolean firstRow;
    boolean supportAutoIncrement;

    AttributeProcessor(DbAdapter adapter) {
        this.adapter = adapter;
        this.firstRow = true;
    }

    private boolean checkForAutoIncrement(ResultSet rs) throws SQLException {
        ResultSetMetaData rsMetaData = rs.getMetaData();
        for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
            if (!"IS_AUTOINCREMENT".equals(rsMetaData.getColumnLabel(i))) continue;
            return true;
        }
        return false;
    }

    void processAttribute(ResultSet rs, PatternFilter columnFilter, DbEntity entity) throws SQLException {
        if (this.firstRow) {
            this.supportAutoIncrement = this.checkForAutoIncrement(rs);
            this.firstRow = false;
        }
        String columnName = rs.getString("COLUMN_NAME");
        if (columnFilter == null || !columnFilter.isIncluded(columnName)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip column '" + entity.getName() + "." + columnName + "' (Path: " + entity.getCatalog() + "/" + entity.getSchema() + "; Filter: " + columnFilter + ")");
            }
            return;
        }
        DbAttribute attribute = this.createDbAttribute(rs);
        this.addToDbEntity(entity, attribute);
    }

    private void addToDbEntity(DbEntity entity, DbAttribute attribute) {
        attribute.setEntity(entity);
        if (entity.getAttribute(attribute.getName()) != null) {
            entity.removeAttribute(attribute.getName());
        }
        entity.addAttribute(attribute);
    }

    private DbAttribute createDbAttribute(ResultSet rs) throws SQLException {
        int columnType = rs.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal(columnType)) {
            decimalDigits = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                decimalDigits = -1;
            }
        }
        DetectedDbAttribute detectedDbAttribute = new DetectedDbAttribute(this.adapter.buildAttribute(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), columnType, rs.getInt("COLUMN_SIZE"), decimalDigits, rs.getBoolean("NULLABLE")));
        detectedDbAttribute.setJdbcTypeName(rs.getString("TYPE_NAME"));
        if (this.supportAutoIncrement && "YES".equals(rs.getString("IS_AUTOINCREMENT"))) {
            detectedDbAttribute.setGenerated(true);
        }
        return detectedDbAttribute;
    }
}

