/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.model.DetectedDbAttribute;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.EntityMergeListener;
import org.apache.cayenne.value.Json;
import org.apache.cayenne.value.Wkt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityMergeSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMergeSupport.class);
    private static final Map<String, String> CLASS_TO_PRIMITIVE = new HashMap<String, String>();
    private static final Map<Integer, String> SQL_TYPE_TO_JAVA8_TYPE = new HashMap<Integer, String>();
    private static final Map<String, String> SQL_ADDITIONAL_TYPES_TO_JAVA_TYPE = new HashMap<String, String>();
    private ObjectNameGenerator nameGenerator;
    private final List<EntityMergeListener> listeners = new ArrayList<EntityMergeListener>();
    private final boolean removingMeaningfulFKs;
    private final NameFilter meaningfulPKsFilter;
    private final boolean usingJava7Types;

    public EntityMergeSupport(ObjectNameGenerator nameGenerator, NameFilter meaningfulPKsFilter, boolean removingMeaningfulFKs, boolean usingJava7Types) {
        this.nameGenerator = nameGenerator;
        this.removingMeaningfulFKs = removingMeaningfulFKs;
        this.meaningfulPKsFilter = meaningfulPKsFilter;
        this.usingJava7Types = usingJava7Types;
        this.addEntityMergeListener(DeleteRuleUpdater.getEntityMergeListener());
    }

    public boolean isRemovingMeaningfulFKs() {
        return this.removingMeaningfulFKs;
    }

    public boolean synchronizeWithDbEntities(Iterable<ObjEntity> objEntities) {
        boolean changed = false;
        for (ObjEntity nextEntity : objEntities) {
            if (!this.synchronizeWithDbEntity(nextEntity)) continue;
            changed = true;
        }
        return changed;
    }

    public boolean synchronizeWithDbEntity(ObjEntity entity) {
        if (entity == null) {
            return false;
        }
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity == null) {
            return false;
        }
        boolean changed = false;
        if (this.removingMeaningfulFKs) {
            changed = this.getRidOfAttributesThatAreNowSrcAttributesForRelationships(entity);
        }
        changed |= this.addMissingAttributes(entity);
        return changed |= this.addMissingRelationships(entity);
    }

    public boolean synchronizeOnDbAttributeAdded(ObjEntity entity, DbAttribute dbAttribute) {
        Collection<DbRelationship> incomingRels = this.getIncomingRelationships(dbAttribute.getEntity());
        if (this.shouldAddToObjEntity(entity, dbAttribute, incomingRels)) {
            this.addMissingAttribute(entity, dbAttribute);
            return true;
        }
        return false;
    }

    public boolean synchronizeOnDbRelationshipAdded(ObjEntity entity, DbRelationship dbRelationship) {
        if (this.shouldAddToObjEntity(entity, dbRelationship)) {
            this.addMissingRelationship(entity, dbRelationship);
            if (this.removingMeaningfulFKs) {
                this.getRidOfAttributesThatAreNowSrcAttributesForRelationships(entity);
            }
        }
        return true;
    }

    private boolean addMissingRelationships(ObjEntity entity) {
        List<DbRelationship> relationshipsToAdd = this.getRelationshipsToAdd(entity);
        if (relationshipsToAdd.isEmpty()) {
            return false;
        }
        for (DbRelationship dr : relationshipsToAdd) {
            this.addMissingRelationship(entity, dr);
        }
        return true;
    }

    private boolean createObjRelationship(ObjEntity entity, DbRelationship dr, String targetEntityName) {
        ObjRelationship or = new ObjRelationship();
        or.setName(NameBuilder.builder(or, entity).baseName(this.nameGenerator.relationshipName(dr)).name());
        or.addDbRelationship(dr);
        Map<String, ObjEntity> objEntities = entity.getDataMap().getSubclassesForObjEntity(entity);
        boolean needGeneratedEntity = !objEntities.containsKey(targetEntityName);
        boolean hasFlattingAttributes = objEntities.values().stream().flatMap(ent -> ent.getAttributes().stream()).map(ObjAttribute::getDbAttributePath).filter(Objects::nonNull).filter(path -> path.length() > 1).anyMatch(path -> path.first().value().equals(dr.getName()));
        if (!hasFlattingAttributes) {
            if (needGeneratedEntity) {
                or.setTargetEntityName(targetEntityName);
                or.setSourceEntity(entity);
            }
            entity.addRelationship(or);
            this.fireRelationshipAdded(or);
        }
        return needGeneratedEntity;
    }

    private boolean addMissingAttributes(ObjEntity entity) {
        boolean changed = false;
        for (DbAttribute da : this.getAttributesToAdd(entity)) {
            this.addMissingAttribute(entity, da);
            changed = true;
        }
        return changed;
    }

    private void addMissingRelationship(ObjEntity entity, DbRelationship dbRelationship) {
        DbEntity targetEntity;
        DataMap dataMap = ((DbEntity)dbRelationship.getSourceEntity()).getDataMap();
        Collection<ObjEntity> mappedObjEntities = dataMap.getMappedEntities(targetEntity = dbRelationship.getTargetEntity());
        if (mappedObjEntities.isEmpty()) {
            boolean needGeneratedEntity;
            if (targetEntity == null) {
                targetEntity = new DbEntity(dbRelationship.getTargetEntityName());
            }
            if (dbRelationship.getTargetEntityName() != null && (needGeneratedEntity = this.createObjRelationship(entity, dbRelationship, this.nameGenerator.objEntityName(targetEntity)))) {
                LOGGER.warn("Can't find ObjEntity for " + dbRelationship.getTargetEntityName());
                LOGGER.warn("Db Relationship (" + dbRelationship + ") will have GUESSED Obj Relationship reflection. ");
            }
        } else {
            for (ObjEntity mappedTarget : mappedObjEntities) {
                this.createObjRelationship(entity, dbRelationship, mappedTarget.getName());
            }
        }
    }

    private void addMissingAttribute(ObjEntity entity, DbAttribute da) {
        ObjAttribute oa = new ObjAttribute();
        oa.setName(NameBuilder.builder(oa, entity).baseName(this.nameGenerator.objAttributeName(da)).name());
        oa.setEntity(entity);
        oa.setType(this.getTypeForObjAttribute(da));
        oa.setDbAttributePath(da.getName());
        entity.addAttribute(oa);
        this.fireAttributeAdded(oa);
    }

    private String getTypeForObjAttribute(DbAttribute dbAttribute) {
        String type;
        DetectedDbAttribute detectedDbAttribute;
        String jdbcTypeName;
        String java8Type;
        if (!this.usingJava7Types && (java8Type = SQL_TYPE_TO_JAVA8_TYPE.get(dbAttribute.getType())) != null) {
            return java8Type;
        }
        if (dbAttribute instanceof DetectedDbAttribute && (jdbcTypeName = (detectedDbAttribute = (DetectedDbAttribute)dbAttribute).getJdbcTypeName()) != null && (type = SQL_ADDITIONAL_TYPES_TO_JAVA_TYPE.get(jdbcTypeName.toLowerCase())) != null) {
            return type;
        }
        String type2 = TypesMapping.getJavaBySqlType(dbAttribute.getType());
        String primitiveType = CLASS_TO_PRIMITIVE.get(type2);
        if (primitiveType != null && dbAttribute.isMandatory()) {
            return primitiveType;
        }
        return type2;
    }

    private boolean getRidOfAttributesThatAreNowSrcAttributesForRelationships(ObjEntity entity) {
        boolean changed = false;
        for (DbAttribute da : this.getMeaningfulFKs(entity)) {
            ObjAttribute oa = entity.getAttributeForDbAttribute(da);
            while (oa != null) {
                String attrName = oa.getName();
                entity.removeAttribute(attrName);
                changed = true;
                oa = entity.getAttributeForDbAttribute(da);
            }
        }
        return changed;
    }

    public Collection<DbAttribute> getMeaningfulFKs(ObjEntity objEntity) {
        ArrayList<DbAttribute> fks = new ArrayList<DbAttribute>(2);
        for (ObjAttribute property : objEntity.getAttributes()) {
            DbAttribute column = property.getDbAttribute();
            if (column == null || !column.isForeignKey()) continue;
            fks.add(column);
        }
        return fks;
    }

    private List<DbAttribute> getAttributesToAdd(ObjEntity objEntity) {
        DbEntity dbEntity = objEntity.getDbEntity();
        ArrayList<DbAttribute> missing = new ArrayList<DbAttribute>();
        Collection<DbRelationship> incomingRels = this.getIncomingRelationships(dbEntity);
        for (DbAttribute dba : dbEntity.getAttributes()) {
            if (!this.shouldAddToObjEntity(objEntity, dba, incomingRels)) continue;
            missing.add(dba);
        }
        return missing;
    }

    private boolean shouldAddToObjEntity(ObjEntity entity, DbAttribute dbAttribute, Collection<DbRelationship> incomingRels) {
        if (dbAttribute.getName() == null || entity.getAttributeForDbAttribute(dbAttribute) != null) {
            return false;
        }
        boolean addMeaningfulPK = this.meaningfulPKsFilter.isIncluded(entity.getDbEntityName());
        if (dbAttribute.isPrimaryKey()) {
            return addMeaningfulPK;
        }
        if (this.isFK(dbAttribute, dbAttribute.getEntity().getRelationships(), true)) {
            return false;
        }
        return !this.isFK(dbAttribute, incomingRels, false);
    }

    private boolean isFK(DbAttribute dbAttribute, Collection<DbRelationship> collection, boolean source) {
        for (DbRelationship rel : collection) {
            for (DbJoin join : rel.getJoins()) {
                DbAttribute joinAttribute = source ? join.getSource() : join.getTarget();
                if (joinAttribute != dbAttribute) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shouldAddToObjEntity(ObjEntity entity, DbRelationship dbRelationship) {
        if (dbRelationship.getName() == null) {
            return false;
        }
        for (ObjRelationship objRelationship : entity.getRelationships()) {
            if (!this.objRelationshipHasDbRelationship(objRelationship, dbRelationship)) continue;
            return false;
        }
        return true;
    }

    private boolean objRelationshipHasDbRelationship(ObjRelationship objRelationship, DbRelationship dbRelationship) {
        for (DbRelationship relationship : objRelationship.getDbRelationships()) {
            if (!relationship.getSourceEntityName().equals(dbRelationship.getSourceEntityName()) || !relationship.getTargetEntityName().equals(dbRelationship.getTargetEntityName()) || !this.isSameAttributes(relationship.getSourceAttributes(), dbRelationship.getSourceAttributes()) || !this.isSameAttributes(relationship.getTargetAttributes(), dbRelationship.getTargetAttributes())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameAttributes(Collection<DbAttribute> collection1, Collection<DbAttribute> collection2) {
        if (collection1.size() != collection2.size()) {
            return false;
        }
        if (collection1.isEmpty()) {
            return true;
        }
        Iterator<DbAttribute> iterator1 = collection1.iterator();
        Iterator<DbAttribute> iterator2 = collection2.iterator();
        for (int i = 0; i < collection1.size(); ++i) {
            DbAttribute attr1 = iterator1.next();
            DbAttribute attr2 = iterator2.next();
            if (attr1 == null) {
                if (attr2 == null) continue;
                return false;
            }
            if (attr2 == null) {
                return false;
            }
            if (!(attr1.getName() == null ? attr2.getName() != null : !attr1.getName().equals(attr2.getName()))) continue;
            return false;
        }
        return true;
    }

    private Collection<DbRelationship> getIncomingRelationships(DbEntity entity) {
        ArrayList<DbRelationship> incoming = new ArrayList<DbRelationship>();
        for (DbEntity nextEntity : entity.getDataMap().getDbEntities()) {
            for (DbRelationship relationship : nextEntity.getRelationships()) {
                if (entity != relationship.getTargetEntity()) continue;
                incoming.add(relationship);
            }
        }
        return incoming;
    }

    protected List<DbRelationship> getRelationshipsToAdd(ObjEntity objEntity) {
        ArrayList<DbRelationship> missing = new ArrayList<DbRelationship>();
        for (DbRelationship dbRel : objEntity.getDbEntity().getRelationships()) {
            if (!this.shouldAddToObjEntity(objEntity, dbRel)) continue;
            missing.add(dbRel);
        }
        return missing;
    }

    public void addEntityMergeListener(EntityMergeListener listener) {
        this.listeners.add(listener);
    }

    public void removeEntityMergeListener(EntityMergeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireAttributeAdded(ObjAttribute attr) {
        for (EntityMergeListener listener : this.listeners) {
            listener.objAttributeAdded(attr);
        }
    }

    private void fireRelationshipAdded(ObjRelationship rel) {
        for (EntityMergeListener listener : this.listeners) {
            listener.objRelationshipAdded(rel);
        }
    }

    public void setNameGenerator(ObjectNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    static {
        CLASS_TO_PRIMITIVE.put(Byte.class.getName(), "byte");
        CLASS_TO_PRIMITIVE.put(Long.class.getName(), "long");
        CLASS_TO_PRIMITIVE.put(Double.class.getName(), "double");
        CLASS_TO_PRIMITIVE.put(Boolean.class.getName(), "boolean");
        CLASS_TO_PRIMITIVE.put(Float.class.getName(), "float");
        CLASS_TO_PRIMITIVE.put(Short.class.getName(), "short");
        CLASS_TO_PRIMITIVE.put(Integer.class.getName(), "int");
        SQL_TYPE_TO_JAVA8_TYPE.put(91, "java.time.LocalDate");
        SQL_TYPE_TO_JAVA8_TYPE.put(92, "java.time.LocalTime");
        SQL_TYPE_TO_JAVA8_TYPE.put(93, "java.time.LocalDateTime");
        SQL_ADDITIONAL_TYPES_TO_JAVA_TYPE.put("json", Json.class.getName());
        SQL_ADDITIONAL_TYPES_TO_JAVA_TYPE.put("geometry", Wkt.class.getName());
    }
}

