/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.ArrayList;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.SelectBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.EmptyNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.InNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TrimmingColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;
import org.apache.cayenne.util.ArrayUtil;

public class OracleSQLTreeProcessor
extends BaseSQLTreeProcessor {
    private static final int ORACLE_IN_BATCH_SIZE = 1000;
    private SelectBuilder selectBuilder;
    private Node root;

    @Override
    protected void onResultNode(Node parent, Node child, int index) {
        for (int i = 0; i < child.getChildrenCount(); ++i) {
            child.replaceChild(i, SQLBuilder.aliased(child.getChild(i), "c" + i).build());
        }
    }

    @Override
    protected void onColumnNode(Node parent, ColumnNode child, int index) {
        OracleSQLTreeProcessor.replaceChild(parent, index, new TrimmingColumnNode(child));
    }

    @Override
    protected void onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        if (child.getLimit() > 0 || child.getOffset() > 0) {
            int limit = child.getLimit();
            int offset = child.getOffset();
            int max = limit <= 0 ? Integer.MAX_VALUE : limit + offset;
            this.selectBuilder = SQLBuilder.select(SQLBuilder.all()).from((NodeBuilder)SQLBuilder.select(SQLBuilder.text(" tid.*"), SQLBuilder.text(" ROWNUM rnum")).from(SQLBuilder.aliased(() -> this.root, "tid")).where(SQLBuilder.exp(SQLBuilder.text(" ROWNUM")).lte(SQLBuilder.value(max)))).where(SQLBuilder.exp(SQLBuilder.text(" rnum")).gt(SQLBuilder.value(offset)));
        }
        parent.replaceChild(index, new EmptyNode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onInNode(Node parent, InNode child, int index) {
        void var10_21;
        int n;
        int n2;
        Object[] slice2;
        boolean not = child.isNot();
        Node arg = child.getChild(0);
        Node childNode = child.getChild(1);
        if (childNode.getType() != NodeType.VALUE) {
            return;
        }
        ValueNode valueNode = (ValueNode)childNode;
        Object value = valueNode.getValue();
        if (!value.getClass().isArray()) {
            return;
        }
        ArrayList<InNode> newChildren = new ArrayList<InNode>();
        if (value instanceof Object[]) {
            for (Object[] slice2 : ArrayUtil.sliceArray((Object[])value, 1000)) {
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof int[]) {
            int[][] nArray = ArrayUtil.sliceArray((int[])value, 1000);
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = nArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof long[]) {
            long[][] lArray = ArrayUtil.sliceArray((long[])value, 1000);
            n2 = lArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = lArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof float[]) {
            float[][] fArray = ArrayUtil.sliceArray((float[])value, 1000);
            n2 = fArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = fArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof double[]) {
            double[][] dArray = ArrayUtil.sliceArray((double[])value, 1000);
            n2 = dArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = dArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof short[]) {
            short[][] sArray = ArrayUtil.sliceArray((short[])value, 1000);
            n2 = sArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = sArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof char[]) {
            char[][] cArray = ArrayUtil.sliceArray((char[])value, 1000);
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = cArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof boolean[]) {
            boolean[][] blArray = ArrayUtil.sliceArray((boolean[])value, 1000);
            n2 = blArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = blArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof byte[]) {
            byte[][] byArray = ArrayUtil.sliceArray((byte[])value, 1000);
            n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = byArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        }
        ExpressionNodeBuilder expressionNodeBuilder = SQLBuilder.exp(SQLBuilder.node((Node)newChildren.get(0)));
        for (int i = 1; i < newChildren.size(); ++i) {
            if (not) {
                ExpressionNodeBuilder expressionNodeBuilder2 = var10_21.and(SQLBuilder.node((Node)newChildren.get(i)));
                continue;
            }
            ExpressionNodeBuilder expressionNodeBuilder3 = var10_21.or(SQLBuilder.node((Node)newChildren.get(i)));
        }
        parent.replaceChild(index, var10_21.build());
    }

    private InNode newSliceNode(InNode child, Node arg, ValueNode valueNode, Object slice) {
        InNode nextNode = new InNode(child.isNot());
        nextNode.addChild((Node)arg.deepCopy());
        nextNode.addChild(new ValueNode(slice, valueNode.isArray(), valueNode.getAttribute(), valueNode.isNeedBinding()));
        return nextNode;
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        String functionName = child.getFunctionName();
        Node functionReplacement = null;
        switch (functionName) {
            case "LOCATE": {
                functionReplacement = new FunctionNode("INSTR", child.getAlias(), true);
                for (int i = 0; i <= 1; ++i) {
                    functionReplacement.addChild(child.getChild(1 - i));
                }
                parent.replaceChild(index, functionReplacement);
                return;
            }
            case "DAY_OF_YEAR": 
            case "DAY_OF_WEEK": 
            case "WEEK": {
                functionReplacement = new FunctionNode("TO_CHAR", child.getAlias(), true);
                functionReplacement.addChild(child.getChild(0));
                functionName = "DAY_OF_YEAR".equals(functionName) ? "'DDD'" : ("DAY_OF_WEEK".equals(functionName) ? "'D'" : "'IW'");
                functionReplacement.addChild(new TextNode(functionName));
                parent.replaceChild(index, functionReplacement);
                return;
            }
            case "SUBSTRING": {
                functionReplacement = new FunctionNode("SUBSTR", child.getAlias(), true);
                break;
            }
            case "CONCAT": {
                functionReplacement = new OpExpressionNode("||");
                break;
            }
            case "CURRENT_TIMESTAMP": 
            case "CURRENT_DATE": {
                functionReplacement = new FunctionNode(functionName, child.getAlias(), false);
                break;
            }
            case "CURRENT_TIME": {
                functionReplacement = new FunctionNode("{fn CURTIME()}", child.getAlias(), false);
                break;
            }
            case "YEAR": 
            case "MONTH": 
            case "DAY": 
            case "DAY_OF_MONTH": 
            case "HOUR": 
            case "MINUTE": 
            case "SECOND": {
                functionReplacement = new FunctionNode("EXTRACT", child.getAlias(), true){

                    @Override
                    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
                        buffer.append(' ');
                    }
                };
                if ("DAY_OF_MONTH".equals(functionName)) {
                    functionName = "DAY";
                }
                functionReplacement.addChild(new TextNode(functionName + " FROM "));
            }
        }
        if (functionReplacement != null) {
            OracleSQLTreeProcessor.replaceChild(parent, index, functionReplacement);
        }
    }

    @Override
    public Node process(Node node) {
        this.root = node;
        super.process(node);
        if (this.selectBuilder != null) {
            return this.selectBuilder.build();
        }
        return node;
    }
}

