/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.cayenne.access.types.ValueObjectType;

public class LocalTimeValueType
implements ValueObjectType<LocalTime, Time> {
    @Override
    public Class<Time> getTargetType() {
        return Time.class;
    }

    @Override
    public Class<LocalTime> getValueType() {
        return LocalTime.class;
    }

    @Override
    public LocalTime toJavaObject(Time value) {
        Instant instant = Instant.ofEpochMilli(value.getTime());
        return LocalTime.ofInstant(instant, ZoneId.systemDefault());
    }

    @Override
    public Time fromJavaObject(LocalTime object) {
        LocalDateTime epochDateTime = object.atDate(LocalDate.EPOCH);
        ZonedDateTime zonedDateTime = epochDateTime.atZone(ZoneId.systemDefault());
        long epochMillis = zonedDateTime.toInstant().toEpochMilli();
        return new Time(epochMillis);
    }

    @Override
    public String toCacheKey(LocalTime object) {
        return object.toString();
    }
}

