/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.SQLTemplateDescriptor;
import org.apache.cayenne.project.validation.BaseQueryValidator;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class SQLTemplateValidator
extends BaseQueryValidator<SQLTemplateDescriptor> {
    public SQLTemplateValidator(Supplier<ValidationConfig> configSupplier) {
        super(configSupplier);
    }

    @Override
    protected ConfigurationNodeValidator.Performer<SQLTemplateDescriptor> validateQuery(SQLTemplateDescriptor query, ValidationResult validationResult) {
        return super.validateQuery(query, validationResult).performIfEnabled(Inspection.SQL_TEMPLATE_NO_ROOT, this::checkForRoot).performIfEnabled(Inspection.SQL_TEMPLATE_NO_DEFAULT_SQL, this::checkForDefaultSQL);
    }

    private void checkForRoot(SQLTemplateDescriptor query, ValidationResult validationResult) {
        DataMap map = query.getDataMap();
        if (query.getRoot() == null && map != null) {
            this.addFailure(validationResult, query, "SQLTemplate query '%s' has no root", query.getName());
        }
    }

    private void checkForDefaultSQL(SQLTemplateDescriptor query, ValidationResult validationResult) {
        if (!Util.isEmptyString((CharSequence)query.getSql())) {
            return;
        }
        for (Map.Entry entry : query.getAdapterSql().entrySet()) {
            if (Util.isEmptyString((CharSequence)((CharSequence)entry.getValue()))) continue;
            return;
        }
        this.addFailure(validationResult, query, "SQLTemplate query '%s' has no default SQL template", query.getName());
    }
}

