/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.PrefetchModel;
import org.apache.cayenne.modeler.editor.SelectQueryOrderingTab;
import org.apache.cayenne.modeler.undo.AddPrefetchUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.EntityTreeFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;

public class SelectQueryPrefetchTab
extends SelectQueryOrderingTab {
    static final String JOINT_PREFETCH_SEMANTICS = "Joint";
    static final String DISJOINT_PREFETCH_SEMANTICS = "Disjoint";
    static final String DISJOINT_BY_ID_PREFETCH_SEMANTICS = "Disjoint by id";
    static final String UNDEFINED_SEMANTICS = "Undefined semantics";

    public SelectQueryPrefetchTab(ProjectController mediator) {
        super(mediator);
    }

    @Override
    protected void initFromModel() {
        super.initFromModel();
        if (this.table.getColumnModel().getColumns().hasMoreElements()) {
            this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        }
    }

    protected void setUpPrefetchBox(TableColumn column) {
        JComboBox<String> prefetchBox = new JComboBox<String>();
        prefetchBox.addItem(JOINT_PREFETCH_SEMANTICS);
        prefetchBox.addItem(DISJOINT_PREFETCH_SEMANTICS);
        prefetchBox.addItem(DISJOINT_BY_ID_PREFETCH_SEMANTICS);
        prefetchBox.addActionListener(e -> Application.getInstance().getFrameController().getEditorView().getEventController().setDirty(true));
        column.setCellEditor(new DefaultCellEditor(prefetchBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Click for combo box");
        column.setCellRenderer(renderer);
    }

    @Override
    protected JComponent createToolbar() {
        CayenneAction.CayenneToolbarButton add = new CayenneAction.CayenneToolbarButton(null, 1);
        ((AbstractButton)add).setText("Add Prefetch");
        ImageIcon addIcon = ModelerUtil.buildIcon("icon-plus.png");
        add.setIcon(addIcon);
        add.setDisabledIcon(FilteredIconFactory.createDisabledIcon(addIcon));
        add.addActionListener(e -> {
            String prefetch = this.getSelectedPath();
            if (prefetch == null) {
                return;
            }
            this.addPrefetch(prefetch);
            Application.getInstance().getUndoManager().addEdit(new AddPrefetchUndoableEdit(prefetch, this));
        });
        CayenneAction.CayenneToolbarButton remove = new CayenneAction.CayenneToolbarButton(null, 3);
        ((AbstractButton)remove).setText("Remove Prefetch");
        ImageIcon removeIcon = ModelerUtil.buildIcon("icon-trash.png");
        remove.setIcon(removeIcon);
        remove.setDisabledIcon(FilteredIconFactory.createDisabledIcon(removeIcon));
        remove.addActionListener(e -> {
            int selection = this.table.getSelectedRow();
            if (selection < 0) {
                return;
            }
            String prefetch = (String)this.table.getModel().getValueAt(selection, 0);
            this.removePrefetch(prefetch);
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setBorder(BorderFactory.createEmptyBorder());
        toolBar.setFloatable(false);
        toolBar.add(add);
        toolBar.add(remove);
        return toolBar;
    }

    @Override
    protected TreeModel createBrowserModel(Entity entity) {
        EntityTreeModel treeModel = new EntityTreeModel(entity);
        treeModel.setFilter(new EntityTreeFilter(){

            @Override
            public boolean attributeMatch(Object node, Attribute attr) {
                return false;
            }

            @Override
            public boolean relationshipMatch(Object node, Relationship rel) {
                return true;
            }
        });
        return treeModel;
    }

    @Override
    protected TableModel createTableModel() {
        return new PrefetchModel(this.selectQuery.getPrefetchesMap(), this.selectQuery.getRoot());
    }

    public void addPrefetch(String prefetch) {
        if (!this.selectQuery.getPrefetchesMap().isEmpty() && this.selectQuery.getPrefetchesMap().containsKey(prefetch)) {
            return;
        }
        this.selectQuery.addPrefetch(prefetch, PrefetchModel.getPrefetchType(DISJOINT_PREFETCH_SEMANTICS));
        this.table.setModel(this.createTableModel());
        this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }

    public void removePrefetch(String prefetch) {
        this.selectQuery.removePrefetch(prefetch);
        this.table.setModel(this.createTableModel());
        this.setUpPrefetchBox(this.table.getColumnModel().getColumn(2));
        this.mediator.fireQueryEvent(new QueryEvent((Object)this, this.selectQuery));
    }
}

