/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.LinkDataMapAction;
import org.apache.cayenne.modeler.dialog.datamap.CatalogUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.LockingUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.PackageUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.SchemaUpdateController;
import org.apache.cayenne.modeler.dialog.datamap.SuperclassUpdateController;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.project.extension.info.ObjectInfo;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationException;

public class DataMapView
extends JPanel {
    protected ProjectController eventController;
    protected TextAdapter name;
    protected JLabel location;
    protected JComboBox<DataNodeDescriptor> nodeSelector;
    protected JCheckBox defaultLockType;
    protected TextAdapter defaultCatalog;
    protected TextAdapter defaultSchema;
    protected TextAdapter defaultPackage;
    protected TextAdapter defaultSuperclass;
    protected JCheckBox quoteSQLIdentifiers;
    protected TextAdapter comment;
    protected JButton updateDefaultCatalog;
    protected JButton updateDefaultSchema;
    protected JButton updateDefaultPackage;
    protected JButton updateDefaultSuperclass;
    protected JButton updateDefaultLockType;
    protected JCheckBox clientSupport;
    protected JLabel defaultClientPackageLabel;
    protected JLabel defaultClientSuperclassLabel;
    protected TextAdapter defaultClientPackage;
    protected TextAdapter defaultClientSuperclass;
    protected JButton updateDefaultClientPackage;
    protected JButton updateDefaultClientSuperclass;

    public DataMapView(ProjectController eventController) {
        this.eventController = eventController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.name = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDataMapName(text);
            }
        };
        this.location = new JLabel();
        this.nodeSelector = Application.getWidgetFactory().createUndoableComboBox();
        this.nodeSelector.setRenderer(CellRenderers.listRendererWithIcons());
        this.updateDefaultCatalog = new JButton("Update...");
        this.defaultCatalog = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultCatalog(text);
            }
        };
        this.updateDefaultSchema = new JButton("Update...");
        this.defaultSchema = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultSchema(text);
            }
        };
        this.quoteSQLIdentifiers = new JCayenneCheckBox();
        this.comment = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                DataMapView.this.updateComment(text);
            }
        };
        this.updateDefaultPackage = new JButton("Update...");
        this.defaultPackage = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultPackage(text);
            }
        };
        this.updateDefaultSuperclass = new JButton("Update...");
        this.defaultSuperclass = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultSuperclass(text);
            }
        };
        this.updateDefaultLockType = new JButton("Update...");
        this.defaultLockType = new JCayenneCheckBox();
        this.clientSupport = new JCayenneCheckBox();
        this.updateDefaultClientPackage = new JButton("Update...");
        this.defaultClientPackage = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultClientPackage(text);
            }
        };
        this.updateDefaultClientSuperclass = new JButton("Update...");
        this.defaultClientSuperclass = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) {
                DataMapView.this.setDefaultClientSuperclass(text);
            }
        };
        FormLayout layout = new FormLayout("right:70dlu, 3dlu, fill:180dlu, 3dlu, fill:120", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator("DataMap Configuration");
        builder.append("DataMap Name:", (Component)this.name.getComponent(), 2);
        builder.append("File:", (Component)this.location, 3);
        builder.append("DataNode:", this.nodeSelector, 2);
        builder.append("Quote SQL Identifiers:", (Component)this.quoteSQLIdentifiers, 3);
        builder.append("Comment:", (Component)this.comment.getComponent(), 2);
        builder.appendSeparator("Entity Defaults");
        builder.append("DB Catalog:", (Component)this.defaultCatalog.getComponent(), (Component)this.updateDefaultCatalog);
        builder.append("DB Schema:", (Component)this.defaultSchema.getComponent(), (Component)this.updateDefaultSchema);
        builder.append("Java Package:", (Component)this.defaultPackage.getComponent(), (Component)this.updateDefaultPackage);
        builder.append("Custom Superclass:", (Component)this.defaultSuperclass.getComponent(), (Component)this.updateDefaultSuperclass);
        builder.append("Optimistic Locking:", (Component)this.defaultLockType, (Component)this.updateDefaultLockType);
        builder.appendSeparator("Client Class Defaults");
        builder.append("Allow Client Entities:", (Component)this.clientSupport, (Component)new JPanel());
        this.defaultClientPackageLabel = builder.append("Client Java Package:", (Component)this.defaultClientPackage.getComponent(), (Component)this.updateDefaultClientPackage);
        this.defaultClientSuperclassLabel = builder.append("Custom Superclass:", (Component)this.defaultClientSuperclass.getComponent(), (Component)this.updateDefaultClientSuperclass);
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    private void initController() {
        this.eventController.addDataMapDisplayListener(e -> {
            DataMap map = e.getDataMap();
            if (map != null) {
                this.initFromModel(map);
            }
        });
        this.nodeSelector.addActionListener(e -> this.setDataNode());
        this.quoteSQLIdentifiers.addItemListener(e -> this.setQuoteSQLIdentifiers(this.quoteSQLIdentifiers.isSelected()));
        this.defaultLockType.addItemListener(e -> this.setDefaultLockType(this.defaultLockType.isSelected() ? 1 : 0));
        this.clientSupport.addItemListener(e -> this.setClientSupport(this.clientSupport.isSelected()));
        this.updateDefaultClientPackage.addActionListener(e -> this.updateDefaultClientPackage());
        this.updateDefaultClientSuperclass.addActionListener(e -> this.updateDefaultClientSuperclass());
        this.updateDefaultCatalog.addActionListener(e -> this.updateDefaultCatalog());
        this.updateDefaultSchema.addActionListener(e -> this.updateDefaultSchema());
        this.updateDefaultPackage.addActionListener(e -> this.updateDefaultPackage());
        this.updateDefaultSuperclass.addActionListener(e -> this.updateDefaultSuperclass());
        this.updateDefaultLockType.addActionListener(e -> this.updateDefaultLockType());
    }

    private void initFromModel(DataMap map) {
        this.name.setText(map.getName());
        this.location.setText(map.getLocation() != null ? map.getLocation() : "(no file)");
        this.quoteSQLIdentifiers.setSelected(map.isQuotingSQLIdentifiers());
        this.comment.setText(this.getComment(map));
        DataNodeDescriptor[] nodes = ((DataChannelDescriptor)this.eventController.getProject().getRootNode()).getNodeDescriptors().toArray(new DataNodeDescriptor[0]);
        DataNodeDescriptor[] objects = new DataNodeDescriptor[nodes.length + 1];
        if (nodes.length > 0) {
            Arrays.sort(nodes, Comparators.getNamedObjectComparator());
            System.arraycopy(nodes, 0, objects, 1, nodes.length);
        }
        DefaultComboBoxModel<DataNodeDescriptor> model = new DefaultComboBoxModel<DataNodeDescriptor>(objects);
        for (DataNodeDescriptor node : nodes) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            model.setSelectedItem(node);
            break;
        }
        this.nodeSelector.setModel(model);
        this.defaultLockType.setSelected(map.getDefaultLockType() != 0);
        this.defaultPackage.setText(map.getDefaultPackage());
        this.defaultCatalog.setText(map.getDefaultCatalog());
        this.defaultSchema.setText(map.getDefaultSchema());
        this.defaultSuperclass.setText(map.getDefaultSuperclass());
        this.clientSupport.setSelected(map.isClientSupported());
        this.defaultClientPackage.setText(map.getDefaultClientPackage());
        this.defaultClientSuperclass.setText(map.getDefaultClientSuperclass());
        this.toggleClientProperties(map.isClientSupported());
    }

    private void toggleClientProperties(boolean enabled) {
        this.defaultClientPackage.getComponent().setEnabled(enabled);
        this.updateDefaultClientPackage.setEnabled(enabled);
        this.defaultClientPackageLabel.setEnabled(enabled);
        this.defaultClientSuperclassLabel.setEnabled(enabled);
        this.defaultClientSuperclass.getComponent().setEnabled(enabled);
        this.updateDefaultClientSuperclass.setEnabled(enabled);
    }

    void setDefaultLockType(int lockType) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        int oldType = dataMap.getDefaultLockType();
        if (oldType == lockType) {
            return;
        }
        dataMap.setDefaultLockType(lockType);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setClientSupport(boolean flag) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.isClientSupported() != flag) {
            dataMap.setClientSupported(flag);
            this.toggleClientProperties(flag);
            this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
        }
    }

    void setQuoteSQLIdentifiers(boolean flag) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.isQuotingSQLIdentifiers() != flag) {
            dataMap.setQuotingSQLIdentifiers(flag);
            this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
        }
    }

    void setDefaultPackage(String newDefaultPackage) {
        String oldPackage;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newDefaultPackage != null && newDefaultPackage.trim().length() == 0) {
            newDefaultPackage = null;
        }
        if (Util.nullSafeEquals(newDefaultPackage, oldPackage = dataMap.getDefaultPackage())) {
            return;
        }
        dataMap.setDefaultPackage(newDefaultPackage);
        this.eventController.getDataMapPreferences("").setSuperclassPackage(newDefaultPackage, "auto");
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultClientPackage(String newDefaultPackage) {
        String oldPackage;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newDefaultPackage != null && newDefaultPackage.trim().length() == 0) {
            newDefaultPackage = null;
        }
        if (Util.nullSafeEquals(newDefaultPackage, oldPackage = dataMap.getDefaultClientPackage())) {
            return;
        }
        dataMap.setDefaultClientPackage(newDefaultPackage);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultClientSuperclass(String newSuperclass) {
        String oldSuperclass;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSuperclass != null && newSuperclass.trim().length() == 0) {
            newSuperclass = null;
        }
        if (Util.nullSafeEquals(newSuperclass, oldSuperclass = dataMap.getDefaultClientSuperclass())) {
            return;
        }
        dataMap.setDefaultClientSuperclass(newSuperclass);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultCatalog(String newCatalog) {
        String oldCatalog;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newCatalog != null && newCatalog.trim().length() == 0) {
            newCatalog = null;
        }
        if (Util.nullSafeEquals(newCatalog, oldCatalog = dataMap.getDefaultCatalog())) {
            return;
        }
        dataMap.setDefaultCatalog(newCatalog);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultSchema(String newSchema) {
        String oldSchema;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSchema != null && newSchema.trim().length() == 0) {
            newSchema = null;
        }
        if (Util.nullSafeEquals(newSchema, oldSchema = dataMap.getDefaultSchema())) {
            return;
        }
        dataMap.setDefaultSchema(newSchema);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDefaultSuperclass(String newSuperclass) {
        String oldSuperclass;
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (newSuperclass != null && newSuperclass.trim().length() == 0) {
            newSuperclass = null;
        }
        if (Util.nullSafeEquals(newSuperclass, oldSuperclass = dataMap.getDefaultSuperclass())) {
            return;
        }
        dataMap.setDefaultSuperclass(newSuperclass);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    void setDataMapName(String newName) {
        if (newName == null || newName.trim().length() == 0) {
            throw new ValidationException("Enter name for DataMap", new Object[0]);
        }
        DataMap map = this.eventController.getCurrentDataMap();
        DataChannelDescriptor dataChannelDescriptor = (DataChannelDescriptor)Application.getInstance().getProject().getRootNode();
        DataMap matchingMap = dataChannelDescriptor.getDataMap(newName);
        if (matchingMap != null && !matchingMap.equals(map)) {
            throw new ValidationException("There is another DataMap named '" + newName + "'. Use a different name.", new Object[0]);
        }
        String oldName = map.getName();
        if (Util.nullSafeEquals(newName, oldName)) {
            return;
        }
        DataMapDefaults pref = this.eventController.getDataMapPreferences("");
        DataMapEvent e = new DataMapEvent((Object)this, map, map.getName());
        ProjectUtil.setDataMapName((DataChannelDescriptor)this.eventController.getProject().getRootNode(), map, newName);
        pref.copyPreferences(newName);
        this.eventController.fireDataMapEvent(e);
    }

    void setDataNode() {
        DataNodeDescriptor node = (DataNodeDescriptor)this.nodeSelector.getSelectedItem();
        DataMap map = this.eventController.getCurrentDataMap();
        LinkDataMapAction action = this.eventController.getApplication().getActionManager().getAction(LinkDataMapAction.class);
        action.linkDataMap(map, node);
    }

    void updateDefaultCatalog() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getDbEntities().size() > 0 || dataMap.getProcedures().size() > 0) {
            new CatalogUpdateController(this.eventController, dataMap).startupAction();
        }
    }

    void updateDefaultSchema() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getDbEntities().size() > 0 || dataMap.getProcedures().size() > 0) {
            new SchemaUpdateController(this.eventController, dataMap).startupAction();
        }
    }

    void updateDefaultSuperclass() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new SuperclassUpdateController(this.eventController, dataMap, false).startupAction();
        }
    }

    void updateDefaultPackage() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0 || dataMap.getEmbeddables().size() > 0) {
            new PackageUpdateController(this.eventController, dataMap, false).startupAction();
        }
    }

    void updateDefaultClientPackage() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new PackageUpdateController(this.eventController, dataMap, true).startupAction();
        }
    }

    void updateDefaultClientSuperclass() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new SuperclassUpdateController(this.eventController, dataMap, true).startupAction();
        }
    }

    void updateDefaultLockType() {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        if (dataMap.getObjEntities().size() > 0) {
            new LockingUpdateController(this.eventController, dataMap).startup();
        }
    }

    void updateComment(String comment) {
        DataMap dataMap = this.eventController.getCurrentDataMap();
        if (dataMap == null) {
            return;
        }
        ObjectInfo.putToMetaData(this.eventController.getApplication().getMetaData(), dataMap, "comment", comment);
        this.eventController.fireDataMapEvent(new DataMapEvent((Object)this, dataMap));
    }

    private String getComment(DataMap dataMap) {
        return ObjectInfo.getFromMetaData(this.eventController.getApplication().getMetaData(), dataMap, "comment");
    }
}

