/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.graph;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.JGraphLayoutProgress;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;

public class JGraphSpringLayout
implements JGraphLayout,
JGraphLayout.Stoppable {
    protected transient Map displacement = new Hashtable();
    protected double replusiveForce = 10000.0;
    protected double springForce = 0.2;
    protected double springLength = 50.0;
    protected int iteration;
    protected int maxIterations = 0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[] cellLocationX;
    protected double[] cellLocationY;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected JGraphLayoutProgress progress = new JGraphLayoutProgress();

    public JGraphSpringLayout() {
        this(50);
    }

    public JGraphSpringLayout(int n) {
        this.setMaxIterations(n);
    }

    public JGraphLayoutProgress getProgress() {
        return this.progress;
    }

    public void run(JGraphFacade jGraphFacade) {
        int n;
        boolean bl = jGraphFacade.isDirected();
        jGraphFacade.setDirected(true);
        Collection collection = jGraphFacade.getVertices();
        if (collection.isEmpty()) {
            return;
        }
        this.vertexArray = collection.toArray();
        this.dispX = new double[this.vertexArray.length];
        this.dispY = new double[this.vertexArray.length];
        this.cellLocationX = new double[this.vertexArray.length];
        this.cellLocationY = new double[this.vertexArray.length];
        this.isMoveable = new boolean[this.vertexArray.length];
        this.neighbours = new int[this.vertexArray.length][];
        if (this.maxIterations == 0) {
            this.maxIterations = 20 * (int)Math.sqrt(this.vertexArray.length);
        }
        this.progress.reset(this.maxIterations);
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(this.vertexArray.length);
        for (n = 0; n < this.vertexArray.length; ++n) {
            hashtable.put(this.vertexArray[n], new Integer(n));
        }
        for (n = 0; n < this.vertexArray.length; ++n) {
            this.dispX[n] = 0.0;
            this.dispY[n] = 0.0;
            Point2D point2D = jGraphFacade.getLocation(this.vertexArray[n]);
            this.cellLocationX[n] = point2D.getX();
            this.cellLocationY[n] = point2D.getY();
            this.isMoveable[n] = jGraphFacade.isMoveable(this.vertexArray[n]);
            Object[] objectArray = jGraphFacade.getNeighbours(this.vertexArray[n], null, false).toArray();
            this.neighbours[n] = new int[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                int n2;
                Integer n3 = (Integer)hashtable.get(objectArray[i]);
                this.neighbours[n][i] = n3 != null ? (n2 = n3.intValue()) : n;
            }
        }
        this.iteration = 0;
        while (this.iteration < this.maxIterations && !this.progress.isStopped()) {
            this.progress.setProgress(this.iteration);
            this.repulse();
            this.attract();
            this.reposition(jGraphFacade);
            ++this.iteration;
        }
        jGraphFacade.setDirected(bl);
    }

    protected void repulse() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int j = i; j < this.vertexArray.length; ++j) {
                double d;
                if (this.progress.isStopped()) {
                    return;
                }
                if (i == j) continue;
                double d2 = this.cellLocationX[i] - this.cellLocationX[j];
                double d3 = this.cellLocationY[i] - this.cellLocationY[j];
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                if (d4 < 0.1) {
                    d4 = 0.1;
                    d2 = 0.1;
                    d3 = 0.1;
                }
                if ((d = this.replusiveForce / (d4 * d4)) > this.springLength) {
                    d = this.springLength;
                } else if (d < -this.springLength) {
                    d = -this.springLength;
                }
                double d5 = d2 / d4;
                double d6 = d5 * d;
                double d7 = d3 / d4;
                double d8 = d7 * d;
                if (this.isMoveable[i]) {
                    int n = i;
                    this.dispX[n] = this.dispX[n] + d6;
                    int n2 = i;
                    this.dispY[n2] = this.dispY[n2] + d8;
                }
                if (!this.isMoveable[j]) continue;
                int n = j;
                this.dispX[n] = this.dispX[n] - d6;
                int n3 = j;
                this.dispY[n3] = this.dispY[n3] - d8;
            }
        }
    }

    protected void attract() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int j = 0; j < this.neighbours[i].length; ++j) {
                if (this.progress.isStopped()) {
                    return;
                }
                int n = this.neighbours[i][j];
                if (i == n) continue;
                double d = this.cellLocationX[i] - this.cellLocationX[n];
                double d2 = this.cellLocationY[i] - this.cellLocationY[n];
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d3 - this.springLength;
                if (d3 < 1.0) {
                    d3 = 1.0;
                }
                double d5 = d4 * this.springForce;
                double d6 = d / d3;
                double d7 = d2 / d3;
                double d8 = d6 * d5;
                double d9 = d7 * d5;
                if (this.isMoveable[i]) {
                    int n2 = i;
                    this.dispX[n2] = this.dispX[n2] - d8;
                    int n3 = i;
                    this.dispY[n3] = this.dispY[n3] - d9;
                }
                if (!this.isMoveable[n]) continue;
                int n4 = n;
                this.dispX[n4] = this.dispX[n4] + d8;
                int n5 = n;
                this.dispY[n5] = this.dispY[n5] + d9;
            }
        }
    }

    protected void reposition(JGraphFacade jGraphFacade) {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            if (!this.isMoveable[i]) continue;
            int n = i;
            this.cellLocationX[n] = this.cellLocationX[n] + this.dispX[i];
            int n2 = i;
            this.cellLocationY[n2] = this.cellLocationY[n2] + this.dispY[i];
            this.dispX[i] = 0.0;
            this.dispY[i] = 0.0;
            if (this.iteration != this.maxIterations - 1) continue;
            jGraphFacade.setLocation(this.vertexArray[i], this.cellLocationX[i], this.cellLocationY[i]);
        }
    }

    public void setMaxIterations(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("iterations must be a positive integer");
        }
        this.maxIterations = n;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public double getSpringLength() {
        return this.springLength;
    }

    public void setSpringLength(double d) {
        if (d < 0.001) {
            throw new IllegalArgumentException("spring length must be postive and non-zero");
        }
        this.springLength = d;
    }

    public double getSpringForce() {
        return this.springForce;
    }

    public void setSpringForce(double d) {
        this.springForce = d;
    }

    public double getReplusiveForce() {
        return this.replusiveForce;
    }

    public void setReplusiveForce(double d) {
        this.replusiveForce = d;
    }

    public String toString() {
        return "Spring";
    }
}

