/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.Collection;
import java.util.Map;

public class ToStringBuilder {
    protected StringBuilder buffer;
    protected Object object;
    protected int fieldCount;

    public ToStringBuilder(Object object) {
        this.object = object;
        this.buffer = new StringBuilder(128);
        this.appendClassName();
        this.appendIdentityHashCode();
        this.buffer.append('[');
    }

    public ToStringBuilder append(String fieldName, Object value) {
        if (this.fieldCount++ > 0) {
            this.buffer.append(',');
        }
        this.buffer.append(fieldName).append('=');
        if (value == null) {
            this.buffer.append("<null>");
        } else {
            this.appendDetail(value);
        }
        return this;
    }

    protected void appendDetail(Object value) {
        if (value instanceof Collection) {
            this.buffer.append(value);
        } else if (value instanceof Map) {
            this.buffer.append(value);
        } else if (value instanceof long[]) {
            this.appendArray((long[])value);
        } else if (value instanceof int[]) {
            this.appendArray((int[])value);
        } else if (value instanceof short[]) {
            this.appendArray((short[])value);
        } else if (value instanceof byte[]) {
            this.appendArray((byte[])value);
        } else if (value instanceof char[]) {
            this.appendArray((char[])value);
        } else if (value instanceof double[]) {
            this.appendArray((double[])value);
        } else if (value instanceof float[]) {
            this.appendArray((float[])value);
        } else if (value instanceof boolean[]) {
            this.appendArray((boolean[])value);
        } else if (value.getClass().isArray()) {
            this.appendArray((Object[])value);
        } else {
            this.buffer.append(value);
        }
    }

    protected void appendArray(short[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(int[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(float[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(long[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(byte[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(double[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(char[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(boolean[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendArray(Object[] array) {
        this.buffer.append('{');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                this.buffer.append(',');
            }
            this.appendDetail(array[i]);
        }
        this.buffer.append('}');
    }

    protected void appendClassName() {
        if (this.object != null) {
            this.buffer.append(this.object.getClass().getName());
        }
    }

    protected void appendIdentityHashCode() {
        if (this.object != null) {
            this.buffer.append('@');
            this.buffer.append(Integer.toHexString(System.identityHashCode(this.object)));
        }
    }

    public String toString() {
        this.buffer.append(']');
        return this.buffer.toString();
    }
}

