/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.control;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.cayenne.util.Util;

public class FileChooser
extends JPanel {
    public static final String CURRENT_DIRECTORY_PROPERTY = "currentDirectory";
    protected boolean existingOnly;
    protected boolean allowFiles = true;
    protected boolean allowDirectories;
    protected FileFilter fileFilter;
    protected String title;
    protected File currentDirectory;
    protected JTextField fileName = new JTextField();
    protected JButton chooseButton = new JButton("...");

    public FileChooser() {
        FormLayout layout = new FormLayout("pref:grow, 3dlu, pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, this);
        builder.append((Component)this.fileName, (Component)this.chooseButton);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooser.this.chooseFileAction();
            }
        });
    }

    public FileChooser(String title, boolean allowFiles, boolean allowDirectories) {
        this();
        this.allowFiles = allowFiles;
        this.allowDirectories = allowDirectories;
        this.title = title;
    }

    public File getFile() {
        String value = this.fileName.getText();
        if (Util.isEmptyString(value)) {
            return null;
        }
        File file = new File(value);
        if (this.existingOnly && !file.exists()) {
            return null;
        }
        return file;
    }

    public void setFile(File file) {
        this.fileName.setText(file != null ? file.getAbsolutePath() : "");
    }

    protected void chooseFileAction() {
        int mode = this.getSelectionMode();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(mode);
        chooser.setDialogType(0);
        chooser.setAcceptAllFileFilterUsed(true);
        if (this.fileFilter != null) {
            chooser.setFileFilter(this.fileFilter);
        }
        if (this.currentDirectory != null) {
            chooser.setCurrentDirectory(this.currentDirectory);
        }
        chooser.setDialogTitle(this.makeTitle(mode));
        int result = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this));
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            this.fileName.setText(selected != null ? selected.getAbsolutePath() : "");
        }
        this.setCurrentDirectory(chooser.getCurrentDirectory());
    }

    protected String makeTitle(int selectionMode) {
        if (this.title != null) {
            return this.title;
        }
        switch (selectionMode) {
            case 2: {
                return "Choose a file or a directory";
            }
            case 1: {
                return "Choose a directory";
            }
        }
        return "Choose a file";
    }

    protected int getSelectionMode() {
        if (this.allowFiles && this.allowDirectories) {
            return 2;
        }
        if (this.allowFiles && !this.allowDirectories) {
            return 0;
        }
        if (!this.allowFiles && this.allowDirectories) {
            return 1;
        }
        return 0;
    }

    public boolean isAllowDirectories() {
        return this.allowDirectories;
    }

    public void setAllowDirectories(boolean allowDirectories) {
        this.allowDirectories = allowDirectories;
    }

    public boolean isAllowFiles() {
        return this.allowFiles;
    }

    public void setAllowFiles(boolean allowFiles) {
        this.allowFiles = allowFiles;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter filteFiler) {
        this.fileFilter = filteFiler;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isExistingOnly() {
        return this.existingOnly;
    }

    public void setExistingOnly(boolean existingOnly) {
        this.existingOnly = existingOnly;
    }

    public void setColumns(int col) {
        this.fileName.setColumns(col);
    }

    public int getColumns() {
        return this.fileName.getColumns();
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        if (!Util.nullSafeEquals(this.currentDirectory, currentDirectory)) {
            File oldValue = this.currentDirectory;
            this.currentDirectory = currentDirectory;
            this.firePropertyChange(CURRENT_DIRECTORY_PROPERTY, oldValue, currentDirectory);
        }
    }
}

