/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerController;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.SaveAction;
import org.apache.cayenne.modeler.dialog.UnsavedChangesDialog;
import org.apache.cayenne.modeler.util.CayenneAction;

public class ProjectAction
extends CayenneAction {
    public static String getActionName() {
        return "Close Project";
    }

    public ProjectAction(Application application) {
        super(ProjectAction.getActionName(), application);
    }

    public ProjectAction(String name, Application application) {
        super(name, application);
    }

    @Override
    public void performAction(ActionEvent e) {
        this.closeProject(true);
    }

    public boolean closeProject(boolean checkUnsaved) {
        if (this.getProjectController() == null || this.getProjectController().getProject() == null) {
            return true;
        }
        if (checkUnsaved && !this.checkSaveOnClose()) {
            return false;
        }
        CayenneModelerController controller = Application.getInstance().getFrameController();
        this.application.getUndoManager().discardAllEdits();
        controller.projectClosedAction();
        return true;
    }

    public boolean checkSaveOnClose() {
        ProjectController projectController = this.getProjectController();
        if (projectController != null && projectController.isDirty()) {
            UnsavedChangesDialog dialog = new UnsavedChangesDialog(Application.getFrame());
            dialog.show();
            if (dialog.shouldCancel()) {
                return false;
            }
            if (dialog.shouldSave()) {
                ActionEvent e = new ActionEvent(this, 1001, "SaveAll");
                Application.getInstance().getActionManager().getAction(SaveAction.class).actionPerformed(e);
                if (projectController.isDirty()) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean enableForPath(Object object) {
        return true;
    }
}

