/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CreateDbEntityUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class CreateDbEntityAction
extends CayenneAction {
    public CreateDbEntityAction(Application application) {
        super(CreateDbEntityAction.getActionName(), application);
    }

    public static String getActionName() {
        return "Create DbEntity";
    }

    static void fireDbEntityEvent(Object src, ProjectController mediator, DbEntity entity) {
        mediator.fireDbEntityEvent(new EntityEvent(src, (Entity)entity, 2));
        EntityDisplayEvent displayEvent = new EntityDisplayEvent(src, entity, mediator.getCurrentDataMap(), mediator.getCurrentDataNode(), (DataChannelDescriptor)mediator.getProject().getRootNode());
        displayEvent.setMainTabFocus(true);
        mediator.fireDbEntityDisplayEvent(displayEvent);
    }

    @Override
    public String getIconName() {
        return "icon-dbentity.png";
    }

    @Override
    public void performAction(ActionEvent e) {
        ProjectController mediator = this.getProjectController();
        DataMap map = mediator.getCurrentDataMap();
        DbEntity entity = new DbEntity();
        entity.setName(NameBuilder.builder(entity, map).name());
        this.createEntity(map, entity);
        this.application.getUndoManager().addEdit(new CreateDbEntityUndoableEdit(map, entity));
    }

    public void createEntity(DataMap map, DbEntity entity) {
        ProjectController mediator = this.getProjectController();
        entity.setCatalog(map.getDefaultCatalog());
        entity.setSchema(map.getDefaultSchema());
        map.addDbEntity(entity);
        CreateDbEntityAction.fireDbEntityEvent(this, mediator, entity);
    }

    @Override
    public boolean enableForPath(ConfigurationNode object) {
        if (object == null) {
            return false;
        }
        return ((Entity)((Object)object)).getDataMap() != null;
    }
}

