/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.init.CayenneModelerModule;
import org.apache.cayenne.modeler.init.platform.PlatformInitializer;
import org.apache.cayenne.project.ProjectModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger logger = LoggerFactory.getLogger(Main.class);
    protected String[] args;

    public static void main(String[] args) {
        try {
            new Main(args).launch();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected Main(String[] args) {
        this.args = args;
    }

    protected void launch() {
        final Injector injector = DIBootstrap.createInjector(this.appendModules(new ArrayList<Module>()));
        injector.getInstance(PlatformInitializer.class).initLookAndFeel();
        logger.info("Starting CayenneModeler.");
        logger.info("JRE v." + System.getProperty("java.version") + " at " + System.getProperty("java.home"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application application = injector.getInstance(Application.class);
                Application.setInstance(application);
                application.startup();
                File project = Main.this.initialProjectFromArgs();
                if (project == null) {
                    project = Main.this.initialProjectFromPreferences();
                }
                if (project != null) {
                    new OpenProjectAction(application).openProject(project);
                }
            }
        });
    }

    protected Collection<Module> appendModules(Collection<Module> modules) {
        modules.add(new ServerModule("CayenneModeler", new String[0]));
        modules.add(new ProjectModule());
        modules.add(new DbSyncModule());
        modules.add(new CayenneModelerModule());
        return modules;
    }

    protected File initialProjectFromPreferences() {
        List<File> lastFiles;
        Preferences autoLoadLastProject = Application.getInstance().getPreferencesNode(GeneralPreferences.class, "");
        if (autoLoadLastProject != null && autoLoadLastProject.getBoolean("autoLoadProject", false) && !(lastFiles = ModelerPreferences.getLastProjFiles()).isEmpty()) {
            return lastFiles.get(0);
        }
        return null;
    }

    protected File initialProjectFromArgs() {
        File f;
        if (this.args != null && this.args.length == 1 && (f = new File(this.args[0])).isFile() && f.getName().startsWith("cayenne") && f.getName().endsWith(".xml")) {
            return f;
        }
        return null;
    }
}

