/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.jdbc.RowDescriptorBuilder;
import org.apache.cayenne.access.jdbc.SQLStatement;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.dba.oracle.OracleResultSetWrapper;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SQLTemplate;

class OracleSQLTemplateAction
extends SQLTemplateAction {
    protected DbEntity dbEntity;

    OracleSQLTemplateAction(SQLTemplate query, DataNode dataNode) {
        super(query, dataNode);
        this.dbEntity = query.getMetaData(dataNode.getEntityResolver()).getDbEntity();
    }

    @Override
    protected void processSelectResult(SQLStatement compiled, Connection connection, Statement statement, ResultSet resultSet, OperationObserver callback, long startTime) throws Exception {
        if (compiled.getResultColumns().length == 0) {
            resultSet = new OracleResultSetWrapper(resultSet);
        }
        super.processSelectResult(compiled, connection, statement, resultSet, callback, startTime);
    }

    @Override
    protected RowDescriptorBuilder configureRowDescriptorBuilder(SQLStatement compiled, ResultSet resultSet) throws SQLException {
        RowDescriptorBuilder builder = super.configureRowDescriptorBuilder(compiled, resultSet);
        return builder;
    }
}

