/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.osgi;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.osgi.OsgiClassLoaderManager;
import org.apache.cayenne.configuration.osgi.OsgiDataDomainProvider;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ClassLoaderManager;
import org.apache.cayenne.di.Module;

public class OsgiModule
implements Module {
    private Class<?> typeFromProjectBundle;
    private Map<String, ClassLoader> perTypeClassLoaders = new HashMap<String, ClassLoader>();

    OsgiModule() {
    }

    void setTypeFromProjectBundle(Class<?> typeFromProjectBundle) {
        this.typeFromProjectBundle = typeFromProjectBundle;
    }

    void putClassLoader(String type, ClassLoader classLoader) {
        this.perTypeClassLoaders.put(type, classLoader);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(ClassLoaderManager.class).toInstance(this.createClassLoaderManager());
        binder.bind(DataDomain.class).toProvider(OsgiDataDomainProvider.class);
    }

    private ClassLoaderManager createClassLoaderManager() {
        return new OsgiClassLoaderManager(this.typeFromProjectBundle.getClassLoader(), this.perTypeClassLoaders);
    }
}

