/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.upgrade;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.configuration.SAXNestedTagHandler;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class DataSourceInfoLoader_3_0_0_1 {
    DataSourceInfoLoader_3_0_0_1() {
    }

    public DataSourceInfo load(Resource configurationResource) throws Exception {
        if (configurationResource == null) {
            throw new NullPointerException("Null configurationResource");
        }
        DataSourceInfo dataSourceDescriptor = new DataSourceInfo();
        XMLReader parser = Util.createXmlReader();
        DriverHandler handler = new DriverHandler(dataSourceDescriptor, parser);
        parser.setContentHandler((ContentHandler)((Object)handler));
        parser.setErrorHandler((ErrorHandler)((Object)handler));
        parser.parse(new InputSource(configurationResource.getURL().openStream()));
        return dataSourceDescriptor;
    }

    private static String passwordFromURL(URL url) {
        InputStream inputStream = null;
        String password = null;
        try {
            inputStream = url.openStream();
            password = DataSourceInfoLoader_3_0_0_1.passwordFromInputStream(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String passwordFromInputStream(InputStream inputStream) {
        String password = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            password = bufferedReader.readLine();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return password;
    }

    private class DriverChildrenHandler
    extends SAXNestedTagHandler {
        private DataSourceInfo dataSourceDescriptor;

        DriverChildrenHandler(XMLReader parser, DriverHandler parentHandler) {
            super(parser, (SAXNestedTagHandler)parentHandler);
            this.dataSourceDescriptor = parentHandler.dataSourceDescriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals("login")) {
                String encoderClass = attributes.getValue("encoderClass");
                String encoderKey = attributes.getValue("encoderKey");
                if (encoderKey == null) {
                    encoderKey = attributes.getValue("encoderSalt");
                }
                String password = attributes.getValue("password");
                String passwordLocation = attributes.getValue("passwordLocation");
                String passwordSource = attributes.getValue("passwordSource");
                if (passwordSource == null) {
                    passwordSource = "model";
                }
                String username = attributes.getValue("userName");
                this.dataSourceDescriptor.setPasswordEncoderClass(encoderClass);
                this.dataSourceDescriptor.setPasswordEncoderKey(encoderKey);
                this.dataSourceDescriptor.setPasswordLocation(passwordLocation);
                this.dataSourceDescriptor.setPasswordSource(passwordSource);
                this.dataSourceDescriptor.setUserName(username);
                if (encoderKey != null) {
                    passwordSource = passwordSource.replaceAll("\\{\\}", encoderKey);
                }
                PasswordEncoding passwordEncoder = this.dataSourceDescriptor.getPasswordEncoder();
                if (passwordLocation != null) {
                    if (passwordLocation.equals("classpath")) {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        URL url = classLoader.getResource(username);
                        if (url != null) {
                            password = DataSourceInfoLoader_3_0_0_1.passwordFromURL(url);
                        }
                    } else if (passwordLocation.equals("url")) {
                        try {
                            password = DataSourceInfoLoader_3_0_0_1.passwordFromURL(new URL(passwordSource));
                        }
                        catch (MalformedURLException classLoader) {}
                    } else if (passwordLocation.equals("executable") && passwordSource != null) {
                        try {
                            Process process = Runtime.getRuntime().exec(passwordSource);
                            password = DataSourceInfoLoader_3_0_0_1.passwordFromInputStream(process.getInputStream());
                            process.waitFor();
                        }
                        catch (IOException iOException) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (password != null && passwordEncoder != null) {
                    this.dataSourceDescriptor.setPassword(passwordEncoder.decodePassword(password, encoderKey));
                }
            } else if (localName.equals("url")) {
                this.dataSourceDescriptor.setDataSourceUrl(attributes.getValue("value"));
            } else if (localName.equals("connectionPool")) {
                String max;
                String min = attributes.getValue("min");
                if (min != null) {
                    try {
                        this.dataSourceDescriptor.setMinConnections(Integer.parseInt(min));
                    }
                    catch (NumberFormatException nfex) {
                        throw new ConfigurationException("Non-numeric 'min' attribute '%s'", (Throwable)nfex, new Object[]{min});
                    }
                }
                if ((max = attributes.getValue("max")) != null) {
                    try {
                        this.dataSourceDescriptor.setMaxConnections(Integer.parseInt(max));
                    }
                    catch (NumberFormatException nfex) {
                        throw new ConfigurationException("Non-numeric 'max' attribute '%s'", (Throwable)nfex, new Object[]{max});
                    }
                }
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }

    private class DriverHandler
    extends SAXNestedTagHandler {
        private DataSourceInfo dataSourceDescriptor;

        DriverHandler(DataSourceInfo dataSourceDescriptor, XMLReader parser) {
            super(parser, null);
            this.dataSourceDescriptor = dataSourceDescriptor;
        }

        protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String name, Attributes attributes) {
            if (localName.equals("driver")) {
                String className = attributes.getValue("", "class");
                this.dataSourceDescriptor.setJdbcDriver(className);
                return new DriverChildrenHandler(this.parser, this);
            }
            return super.createChildTagHandler(namespaceURI, localName, name, attributes);
        }
    }
}

