/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.sql.Driver;
import java.util.Collections;
import javax.sql.DataSource;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.slf4j.Logger;

public class DbGeneratorTask
extends CayenneTask {
    protected boolean dropTables;
    protected boolean dropPK;
    protected boolean createTables = true;
    protected boolean createPK = true;
    protected boolean createFK = true;

    public void execute() {
        AntLogger logger = new AntLogger(this);
        this.log(String.format("connection settings - [driver: %s, url: %s, username: %s]", this.driver, this.url, this.userName), 3);
        this.log(String.format("generator options - [dropTables: %s, dropPK: %s, createTables: %s, createPK: %s, createFK: %s]", this.dropTables, this.dropPK, this.createTables, this.createPK, this.createFK), 3);
        this.validateAttributes();
        ClassLoader loader = null;
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new DbSyncModule(), new ToolsModule((Logger)logger)});
        try {
            loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DbGeneratorTask.class.getClassLoader());
            DataMap dataMap = this.loadDataMap();
            DriverDataSource dataSource = new DriverDataSource((Driver)Class.forName(this.driver).newInstance(), this.url, this.userName, this.password);
            DbAdapter adapter = this.getAdapter(injector, (DataSource)dataSource);
            DbGenerator generator = new DbGenerator(adapter, dataMap, Collections.emptyList(), null, (JdbcEventLogger)NoopJdbcEventLogger.getInstance());
            generator.setShouldCreateFKConstraints(this.createFK);
            generator.setShouldCreatePKSupport(this.createPK);
            generator.setShouldCreateTables(this.createTables);
            generator.setShouldDropPKSupport(this.dropPK);
            generator.setShouldDropTables(this.dropTables);
            generator.runGenerator((DataSource)dataSource);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error generating database";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.log(message, 0);
            throw new BuildException(message, th);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
            injector.shutdown();
        }
    }

    protected void validateAttributes() throws BuildException {
        StringBuilder error = new StringBuilder("");
        if (this.map == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if (this.driver == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (this.url == null) {
            error.append("The 'adapter' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setCreateFK(boolean createFK) {
        this.createFK = createFK;
    }

    public void setCreatePK(boolean createPK) {
        this.createPK = createPK;
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public void setDropPK(boolean dropPK) {
        this.dropPK = dropPK;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }
}

