/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.util.ConversionUtil;

abstract class Evaluator {
    private static final ConcurrentMap<Class<?>, Evaluator> evaluators = new ConcurrentHashMap();
    private static final Evaluator NULL_LHS_EVALUATOR = new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return rhs == null;
        }
    };
    private static final Evaluator DEFAULT_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        boolean eq(Object lhs, Object rhs) {
            return lhs.equals(rhs);
        }

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }
    });
    private static final Evaluator PERSISTENT_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return null;
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            Persistent lhsPersistent = (Persistent)lhs;
            if (rhs instanceof Persistent) {
                return lhsPersistent.getObjectId().equals(((Persistent)rhs).getObjectId());
            }
            if (rhs instanceof ObjectId) {
                return lhsPersistent.getObjectId().equals(rhs);
            }
            if (rhs instanceof Map) {
                return lhsPersistent.getObjectId().getIdSnapshot().equals(rhs);
            }
            if (lhsPersistent.getObjectId().getIdSnapshot().size() != 1) {
                return false;
            }
            if (rhs instanceof Number) {
                if (rhs instanceof Integer) {
                    return Cayenne.longPKForObject(lhsPersistent) == ((Number)rhs).longValue();
                }
                if (rhs instanceof Long) {
                    return Cayenne.longPKForObject(lhsPersistent) == ((Number)rhs).longValue();
                }
            }
            return Cayenne.pkForObject(lhsPersistent).equals(rhs);
        }
    });
    private static final Evaluator BIG_DECIMAL_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return ((BigDecimal)lhs).compareTo(ConversionUtil.toBigDecimal(rhs));
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            Integer c = this.compare(lhs, rhs);
            return c == 0;
        }
    });
    private static final Evaluator NUMBER_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){
        private final List WHOLE_NUMBER_CLASSES = Arrays.asList(Byte.class, Short.class, Integer.class, AtomicInteger.class, Long.class, AtomicLong.class, BigInteger.class);

        @Override
        Integer compare(Object lhs, Object rhs) {
            return this.compareNumbers((Number)lhs, rhs);
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return this.equalNumbers((Number)lhs, rhs);
        }

        Class<?> widestNumberType(Number lhs, Number rhs) {
            if (lhs.getClass().equals(rhs.getClass())) {
                return lhs.getClass();
            }
            int lhsIndex = this.WHOLE_NUMBER_CLASSES.indexOf(lhs.getClass());
            int rhsIndex = this.WHOLE_NUMBER_CLASSES.indexOf(rhs.getClass());
            Class widestClass = lhsIndex != -1 && rhsIndex != -1 ? (Class)this.WHOLE_NUMBER_CLASSES.get(Math.max(lhsIndex, rhsIndex)) : Double.class;
            return widestClass;
        }

        boolean equalNumbers(Number lhs, Object _rhs) {
            if (!Number.class.isAssignableFrom(_rhs.getClass())) {
                return lhs.equals(_rhs);
            }
            Number rhs = (Number)_rhs;
            Class<?> widestClass = this.widestNumberType(lhs, rhs);
            if (Integer.class.equals(widestClass) || AtomicInteger.class.equals(widestClass)) {
                return lhs.intValue() == rhs.intValue();
            }
            if (Long.class.equals(widestClass) || AtomicLong.class.equals(widestClass)) {
                return lhs.longValue() == rhs.longValue();
            }
            if (Double.class.equals(widestClass)) {
                return Math.abs(lhs.doubleValue() - rhs.doubleValue()) < 1.0E-7;
            }
            if (Short.class.equals(widestClass)) {
                return lhs.shortValue() == rhs.shortValue();
            }
            if (BigInteger.class.equals(widestClass)) {
                return lhs.toString().equals(rhs.toString());
            }
            return lhs.equals(rhs);
        }

        Integer compareNumbers(Number lhs, Object _rhs) {
            if (!Number.class.isAssignableFrom(_rhs.getClass())) {
                return null;
            }
            Number rhs = (Number)_rhs;
            Class<?> widestClass = this.widestNumberType(lhs, rhs);
            if (Integer.class.equals(widestClass) || AtomicInteger.class.equals(widestClass)) {
                return Integer.valueOf(lhs.intValue()).compareTo(rhs.intValue());
            }
            if (Long.class.equals(widestClass) || AtomicLong.class.equals(widestClass)) {
                return Long.valueOf(lhs.longValue()).compareTo(rhs.longValue());
            }
            if (Double.class.equals(widestClass)) {
                boolean areEqual = Math.abs(lhs.doubleValue() - rhs.doubleValue()) < 1.0E-7;
                return areEqual ? 0 : Double.compare(lhs.doubleValue(), rhs.doubleValue());
            }
            if (Float.class.equals(widestClass)) {
                boolean areEqual = (double)Math.abs(lhs.floatValue() - rhs.floatValue()) < 1.0E-7;
                return areEqual ? 0 : Float.compare(lhs.floatValue(), rhs.floatValue());
            }
            if (Short.class.equals(widestClass)) {
                return Short.valueOf(lhs.shortValue()).compareTo(rhs.shortValue());
            }
            if (Byte.class.equals(widestClass)) {
                return Byte.valueOf(lhs.byteValue()).compareTo(rhs.byteValue());
            }
            if (BigInteger.class.equals(widestClass)) {
                BigInteger left = lhs instanceof BigInteger ? (BigInteger)lhs : new BigInteger(lhs.toString());
                BigInteger right = rhs instanceof BigInteger ? (BigInteger)rhs : new BigInteger(rhs.toString());
                return left.compareTo(right);
            }
            if (Comparable.class.isAssignableFrom(lhs.getClass())) {
                return ((Comparable)((Object)lhs)).compareTo(rhs);
            }
            return null;
        }
    });
    private static final Evaluator COMPARABLE_EVALUATOR = new NonNullLhsEvaluator(new Evaluator(){

        @Override
        Integer compare(Object lhs, Object rhs) {
            return ((Comparable)lhs).compareTo(ConversionUtil.toComparable(rhs));
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return lhs.equals(rhs);
        }
    });
    private static final double EPSILON = 1.0E-7;

    Evaluator() {
    }

    static Evaluator evaluator(Object lhs) {
        if (lhs == null) {
            return NULL_LHS_EVALUATOR;
        }
        Class<?> lhsType = lhs.getClass();
        Evaluator e = (Evaluator)evaluators.get(lhsType);
        if (e == null) {
            Evaluator created = Evaluator.compileEvaluator(lhsType);
            Evaluator existing = evaluators.putIfAbsent(lhsType, created);
            e = existing != null ? existing : created;
        }
        return e;
    }

    private static Evaluator compileEvaluator(Class<?> lhsType) {
        Evaluator ev = Evaluator.findInHierarchy(lhsType);
        if (ev != null) {
            return ev;
        }
        if (Persistent.class.isAssignableFrom(lhsType)) {
            return PERSISTENT_EVALUATOR;
        }
        if (BigDecimal.class.isAssignableFrom(lhsType)) {
            return BIG_DECIMAL_EVALUATOR;
        }
        if (Number.class.isAssignableFrom(lhsType)) {
            return NUMBER_EVALUATOR;
        }
        if (Comparable.class.isAssignableFrom(lhsType)) {
            return COMPARABLE_EVALUATOR;
        }
        return DEFAULT_EVALUATOR;
    }

    private static Evaluator findInHierarchy(Class<?> lhsType) {
        if (Object.class.equals(lhsType)) {
            return null;
        }
        Evaluator ev = (Evaluator)evaluators.get(lhsType);
        return ev != null ? ev : Evaluator.findInHierarchy(lhsType.getSuperclass());
    }

    abstract boolean eq(Object var1, Object var2);

    abstract Integer compare(Object var1, Object var2);

    static class NonNullLhsEvaluator
    extends Evaluator {
        final Evaluator delegate;

        NonNullLhsEvaluator(Evaluator delegate) {
            this.delegate = delegate;
        }

        @Override
        Integer compare(Object lhs, Object rhs) {
            if (rhs == null) {
                return null;
            }
            return this.delegate.compare(lhs, rhs);
        }

        @Override
        boolean eq(Object lhs, Object rhs) {
            return rhs != null && this.delegate.eq(lhs, rhs);
        }
    }
}

