/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchTranslator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;

class Oracle8LOBInsertBatchTranslator
extends Oracle8LOBBatchTranslator {
    Oracle8LOBInsertBatchTranslator(InsertBatchQuery query, DbAdapter adapter, String trimFunction) {
        super(query, adapter, trimFunction);
    }

    @Override
    List<Object> getValuesForLOBUpdateParameters(BatchQueryRow row) {
        List<DbAttribute> dbAttributes = this.query.getDbAttributes();
        int len = dbAttributes.size();
        ArrayList<Object> values = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute;
            Object value = row.getValue(i);
            if (!this.isUpdateableColumn(value, (attribute = dbAttributes.get(i)).getType())) continue;
            values.add(value);
        }
        return values;
    }

    @Override
    public String createSql(BatchQueryRow row) {
        List<DbAttribute> dbAttributes = this.query.getDbAttributes();
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("INSERT INTO ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        buffer.append(" (");
        Iterator<DbAttribute> i = dbAttributes.iterator();
        while (i.hasNext()) {
            DbAttribute attribute = i.next();
            buffer.append(strategy.quotedName(attribute));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(") VALUES (");
        for (int i2 = 0; i2 < dbAttributes.size(); ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            this.appendUpdatedParameter(buffer, dbAttributes.get(i2), row.getValue(i2));
        }
        buffer.append(')');
        return buffer.toString();
    }
}

