/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorMerger;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.util.XMLSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataChannelDescriptorMerger
implements DataChannelDescriptorMerger {
    private static Logger logger = LoggerFactory.getLogger(DefaultDataChannelDescriptorMerger.class);

    @Override
    public DataChannelDescriptor merge(DataChannelDescriptor ... descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            throw new IllegalArgumentException("Null or empty descriptors");
        }
        if (descriptors.length == 1) {
            return descriptors[0];
        }
        int len = descriptors.length;
        DataChannelDescriptor merged = new DataChannelDescriptor();
        merged.setName(descriptors[len - 1].getName());
        merged.getProperties().putAll(descriptors[len - 1].getProperties());
        for (int i = len - 1; i >= 0; --i) {
            XMLSerializable existing;
            DataChannelDescriptor descriptor = descriptors[i];
            for (DataMap map : descriptor.getDataMaps()) {
                existing = merged.getDataMap(map.getName());
                if (existing != null) {
                    logger.info("Discarding overridden DataMap '" + map.getName() + "' from descriptor '" + descriptor.getName() + "'");
                    continue;
                }
                logger.info("Using DataMap '" + map.getName() + "' from descriptor '" + descriptor.getName() + "' in merged descriptor");
                merged.getDataMaps().add(map);
            }
            for (DataNodeDescriptor node : descriptor.getNodeDescriptors()) {
                existing = merged.getNodeDescriptor(node.getName());
                if (existing != null) {
                    logger.info("Discarding overridden DataNode '" + node.getName() + "' from descriptor '" + descriptor.getName() + "'");
                    for (String mapName : node.getDataMapNames()) {
                        if (((DataNodeDescriptor)existing).getDataMapNames().contains(mapName)) continue;
                        ((DataNodeDescriptor)existing).getDataMapNames().add(mapName);
                    }
                    continue;
                }
                logger.info("Using DataNode '" + node.getName() + "' from descriptor '" + descriptor.getName() + "' in merged descriptor");
                merged.getNodeDescriptors().add(this.cloneDataNodeDescriptor(node, merged));
            }
        }
        return merged;
    }

    protected DataNodeDescriptor cloneDataNodeDescriptor(DataNodeDescriptor original, DataChannelDescriptor targetOwner) {
        DataNodeDescriptor clone = new DataNodeDescriptor(original.getName());
        clone.setAdapterType(original.getAdapterType());
        clone.setDataChannelDescriptor(targetOwner);
        clone.setDataSourceDescriptor(original.getDataSourceDescriptor());
        clone.setDataSourceFactoryType(original.getDataSourceFactoryType());
        clone.setParameters(original.getParameters());
        clone.setSchemaUpdateStrategyType(original.getSchemaUpdateStrategyType());
        clone.getDataMapNames().addAll(original.getDataMapNames());
        return clone;
    }
}

