/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.translator.select.DataObjectMatchTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.QueryAssemblerHelper;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHandler;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.exp.parser.PatternMatchNode;
import org.apache.cayenne.exp.parser.SimpleNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.Transformer;

public class QualifierTranslator
extends QueryAssemblerHelper
implements TraversalHandler {
    protected DataObjectMatchTranslator objectMatchTranslator;
    protected boolean matchingObject;
    protected boolean caseInsensitive = false;
    protected boolean useAliasForExpressions;
    protected Expression waitingForEndNode;
    protected Expression qualifier;

    public QualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void doAppendPart() {
        this.doAppendPart(this.extractQualifier());
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public void setQualifier(Expression qualifier) {
        this.qualifier = qualifier;
    }

    public void setUseAliasForExpressions(boolean useAliasForExpressions) {
        this.useAliasForExpressions = useAliasForExpressions;
    }

    protected void doAppendPart(Expression rootNode) {
        if (rootNode == null) {
            return;
        }
        rootNode.traverse(this);
    }

    protected Expression extractQualifier() {
        Expression dbQualifier;
        ClassDescriptor descriptor;
        Expression entityQualifier;
        if (this.qualifier != null) {
            return this.qualifier;
        }
        Query q = this.queryAssembler.getQuery();
        Expression qualifier = ((SelectQuery)q).getQualifier();
        ObjEntity entity = this.getObjEntity();
        if (entity != null && (entityQualifier = (descriptor = this.queryAssembler.getEntityResolver().getClassDescriptor(entity.getName())).getEntityInheritanceTree().qualifierForEntityAndSubclasses()) != null) {
            Expression expression = qualifier = qualifier != null ? qualifier.andExp(entityQualifier) : entityQualifier;
        }
        if (this.getDbEntity() != null && (dbQualifier = this.getDbEntity().getQualifier()) != null) {
            dbQualifier = dbQualifier.transform(new DbEntityQualifierTransformer());
            qualifier = qualifier == null ? dbQualifier : qualifier.andExp(dbQualifier);
        }
        return qualifier;
    }

    protected void detectObjectMatch(Expression exp) {
        this.matchingObject = false;
        if (exp.getOperandCount() != 2) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            Object op = exp.getOperand(i);
            if (!(op instanceof Persistent) && !(op instanceof ObjectId)) continue;
            this.matchingObject = true;
            if (this.objectMatchTranslator == null) {
                this.objectMatchTranslator = new DataObjectMatchTranslator();
                break;
            }
            this.objectMatchTranslator.reset();
            break;
        }
    }

    protected void appendObjectMatch() throws IOException {
        if (!this.matchingObject || this.objectMatchTranslator == null) {
            throw new IllegalStateException("An invalid attempt to append object match.");
        }
        this.matchingObject = false;
        boolean first = true;
        DbRelationship relationship = this.objectMatchTranslator.getRelationship();
        if (!relationship.isToMany() && !relationship.isToPK()) {
            this.queryAssembler.dbRelationshipAdded(relationship, JoinType.INNER, this.objectMatchTranslator.getJoinSplitAlias());
        }
        Iterator<String> it = this.objectMatchTranslator.keys();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.out.append(" AND ");
            }
            String key = it.next();
            DbAttribute attr = this.objectMatchTranslator.getAttribute(key);
            Object val = this.objectMatchTranslator.getValue(key);
            this.processColumn(attr);
            this.out.append(this.objectMatchTranslator.getOperation());
            this.appendLiteral(val, attr, this.objectMatchTranslator.getExpression());
        }
        this.objectMatchTranslator.reset();
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (this.waitingForEndNode != null) {
            return;
        }
        if (!hasMoreChildren) {
            return;
        }
        StringBuilder out = this.matchingObject ? new StringBuilder() : this.out;
        try {
            switch (node.getType()) {
                case 0: {
                    out.append((CharSequence)" AND ");
                    break;
                }
                case 1: {
                    out.append((CharSequence)" OR ");
                    break;
                }
                case 3: {
                    if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                        out.append((CharSequence)" IS ");
                        break;
                    }
                    out.append((CharSequence)" = ");
                    break;
                }
                case 4: {
                    if (childIndex == 0 && node.getOperandCount() == 2 && node.getOperand(1) == null) {
                        out.append((CharSequence)" IS NOT ");
                        break;
                    }
                    out.append((CharSequence)" <> ");
                    break;
                }
                case 5: {
                    out.append((CharSequence)" < ");
                    break;
                }
                case 6: {
                    out.append((CharSequence)" > ");
                    break;
                }
                case 7: {
                    out.append((CharSequence)" <= ");
                    break;
                }
                case 8: {
                    out.append((CharSequence)" >= ");
                    break;
                }
                case 10: {
                    out.append((CharSequence)" IN ");
                    break;
                }
                case 36: {
                    out.append((CharSequence)" NOT IN ");
                    break;
                }
                case 11: {
                    out.append((CharSequence)" LIKE ");
                    break;
                }
                case 37: {
                    out.append((CharSequence)" NOT LIKE ");
                    break;
                }
                case 12: {
                    if (this.caseInsensitive) {
                        out.append((CharSequence)" LIKE ");
                        break;
                    }
                    out.append((CharSequence)") LIKE UPPER(");
                    break;
                }
                case 38: {
                    if (this.caseInsensitive) {
                        out.append((CharSequence)" NOT LIKE ");
                        break;
                    }
                    out.append((CharSequence)") NOT LIKE UPPER(");
                    break;
                }
                case 16: {
                    out.append((CharSequence)" + ");
                    break;
                }
                case 17: {
                    out.append((CharSequence)" - ");
                    break;
                }
                case 18: {
                    out.append((CharSequence)" * ");
                    break;
                }
                case 19: {
                    out.append((CharSequence)" / ");
                    break;
                }
                case 9: {
                    if (childIndex == 0) {
                        out.append((CharSequence)" BETWEEN ");
                        break;
                    }
                    if (childIndex != 1) break;
                    out.append((CharSequence)" AND ");
                    break;
                }
                case 35: {
                    if (childIndex == 0) {
                        out.append((CharSequence)" NOT BETWEEN ");
                        break;
                    }
                    if (childIndex != 1) break;
                    out.append((CharSequence)" AND ");
                    break;
                }
                case 41: {
                    out.append((CharSequence)" ").append(this.operandForBitwiseOr()).append(" ");
                    break;
                }
                case 40: {
                    out.append((CharSequence)" ").append(this.operandForBitwiseAnd()).append(" ");
                    break;
                }
                case 42: {
                    out.append((CharSequence)" ").append(this.operandForBitwiseXor()).append(" ");
                    break;
                }
                case 43: {
                    out.append((CharSequence)" ").append(this.operandForBitwiseLeftShift()).append(" ");
                    break;
                }
                case 44: {
                    out.append((CharSequence)" ").append(this.operandForBitwiseRightShift()).append("");
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(((Object)out).toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }

    protected String operandForBitwiseNot() {
        return "~";
    }

    protected String operandForBitwiseOr() {
        return "|";
    }

    protected String operandForBitwiseAnd() {
        return "&";
    }

    protected String operandForBitwiseXor() {
        return "^";
    }

    protected String operandForBitwiseLeftShift() {
        return "<<";
    }

    protected String operandForBitwiseRightShift() {
        return ">>";
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        String alias;
        if (this.waitingForEndNode != null) {
            return;
        }
        if (this.useAliasForExpressions && (alias = this.queryAssembler.getAliasForExpression(node)) != null) {
            this.out.append(alias);
            this.waitingForEndNode = node;
            return;
        }
        boolean parenthesisNeeded = this.parenthesisNeeded(node, parentNode);
        if (node.getType() == 45) {
            if (node instanceof ASTExtract) {
                this.appendExtractFunction((ASTExtract)node);
            } else {
                this.appendFunction((ASTFunctionCall)node);
            }
            if (parenthesisNeeded) {
                this.out.append("(");
            }
            return;
        }
        if (node.getType() == 47 && parentNode != null) {
            throw new CayenneRuntimeException("Expression is not supported in where clause.", new Object[0]);
        }
        int count = node.getOperandCount();
        if (count == 2) {
            this.detectObjectMatch(node);
        }
        if (parenthesisNeeded) {
            this.out.append('(');
        }
        if (count == 0) {
            if (node.getType() == 21) {
                this.out.append("1 = 1");
            } else if (node.getType() == 22) {
                this.out.append("1 = 0");
            } else if (node.getType() == 46) {
                this.out.append("*");
            }
        }
        if (count == 1) {
            if (node.getType() == 20) {
                this.out.append('-');
            } else if (node.getType() == 2) {
                this.out.append("NOT ");
            } else if (node.getType() == 39) {
                this.out.append(this.operandForBitwiseNot());
            }
        } else if (!(node.getType() != 12 && node.getType() != 38 || this.caseInsensitive)) {
            this.out.append("UPPER(");
        }
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        if (this.waitingForEndNode != null) {
            if (node == this.waitingForEndNode) {
                this.waitingForEndNode = null;
            }
            return;
        }
        try {
            if (node.getOperandCount() == 2 && this.matchingObject) {
                this.appendObjectMatch();
            }
            boolean parenthesisNeeded = this.parenthesisNeeded(node, parentNode);
            boolean likeIgnoreCase = node.getType() == 12 || node.getType() == 38;
            boolean isPatternMatchNode = PatternMatchNode.class.isAssignableFrom(node.getClass());
            if (likeIgnoreCase && !this.caseInsensitive) {
                this.out.append(')');
            }
            if (isPatternMatchNode) {
                this.appendLikeEscapeCharacter((PatternMatchNode)node);
            }
            if (node.getType() == 45) {
                this.clearLastFunctionArgDivider((ASTFunctionCall)node);
            }
            if (parenthesisNeeded) {
                this.out.append(')');
            }
            if (parentNode != null && parentNode.getType() == 45) {
                this.appendFunctionArgDivider((ASTFunctionCall)parentNode);
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
    }

    @Override
    public void objectNode(Object leaf, Expression parentNode) {
        if (this.waitingForEndNode != null) {
            return;
        }
        try {
            switch (parentNode.getType()) {
                case 26: {
                    this.appendObjPath(parentNode);
                    break;
                }
                case 27: {
                    this.appendDbPath(parentNode);
                    break;
                }
                case 28: {
                    this.appendList(parentNode, this.paramsDbType(parentNode));
                    break;
                }
                case 45: {
                    this.appendFunctionArg(leaf, (ASTFunctionCall)parentNode);
                    break;
                }
                default: {
                    this.appendLiteral(leaf, this.paramsDbType(parentNode), parentNode);
                    break;
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
    }

    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (node.getType() == 45) {
            return ((ASTFunctionCall)node).needParenthesis();
        }
        if (parentNode == null) {
            return false;
        }
        if (node.getOperandCount() > 1) {
            return true;
        }
        return node.getType() != 26 && node.getType() != 27 && node.getType() != 46;
    }

    private final void appendList(Expression listExpr, DbAttribute paramDesc) throws IOException {
        ResettableIterator it;
        Object list = listExpr.getOperand(0);
        if (list instanceof List) {
            it = ((List)list).iterator();
        } else if (list instanceof Object[]) {
            it = IteratorUtils.arrayIterator((Object[])((Object[])list));
        } else {
            String className = list != null ? list.getClass().getName() : "<null>";
            throw new IllegalArgumentException("Unsupported type for the list expressions: " + className);
        }
        if (it.hasNext()) {
            this.appendLiteral(it.next(), paramDesc, listExpr);
        } else {
            return;
        }
        while (it.hasNext()) {
            this.out.append(", ");
            this.appendLiteral(it.next(), paramDesc, listExpr);
        }
    }

    @Override
    protected void appendLiteral(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        if (!this.matchingObject) {
            super.appendLiteral(val, attr, parentExpression);
        } else if (val == null || val instanceof Persistent) {
            this.objectMatchTranslator.setDataObject((Persistent)val);
        } else if (val instanceof ObjectId) {
            this.objectMatchTranslator.setObjectId((ObjectId)val);
        } else {
            throw new IllegalArgumentException("Attempt to use literal other than DataObject during object match.");
        }
    }

    @Override
    protected void processRelTermination(DbRelationship rel, JoinType joinType, String joinSplitAlias) {
        if (!this.matchingObject) {
            super.processRelTermination(rel, joinType, joinSplitAlias);
        } else {
            if (rel.isToMany()) {
                this.queryAssembler.dbRelationshipAdded(rel, joinType, joinSplitAlias);
            }
            this.objectMatchTranslator.setRelationship(rel, joinSplitAlias);
        }
    }

    protected void appendFunction(ASTFunctionCall functionExpression) {
        this.out.append(functionExpression.getFunctionName());
    }

    protected void appendExtractFunction(ASTExtract functionExpression) {
        this.appendFunction(functionExpression);
    }

    protected void appendFunctionArg(Object value, ASTFunctionCall functionExpression) throws IOException {
        DbAttribute dbAttrForArg = new DbAttribute();
        dbAttrForArg.setType(TypesMapping.getSqlTypeByJava(value.getClass()));
        super.appendLiteral(value, dbAttrForArg, functionExpression);
        this.appendFunctionArgDivider(functionExpression);
    }

    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        this.out.append(", ");
    }

    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if (functionExpression.getOperandCount() > 0) {
            this.out.delete(this.out.length() - 2, this.out.length());
        }
    }

    class DbEntityQualifierTransformer
    implements Transformer {
        DbEntityQualifierTransformer() {
        }

        public Object transform(Object input) {
            if (input instanceof ASTObjPath) {
                return new ASTDbPath(((SimpleNode)input).getOperand(0));
            }
            return input;
        }
    }
}

