/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Collection;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.Property;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.util.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyClassDescriptorDecorator
implements ClassDescriptor {
    protected ClassDescriptor descriptor;
    protected ClassDescriptorMap descriptorMap;
    protected String entityName;

    public LazyClassDescriptorDecorator(ClassDescriptorMap descriptorMap, String entityName) {
        this.descriptorMap = descriptorMap;
        this.entityName = entityName;
    }

    public String toString() {
        return new ToStringBuilder(this).append("entity", this.entityName).toString();
    }

    protected void checkDescriptorInitialized() {
        if (this.descriptor == null) {
            this.descriptor = this.descriptorMap.createDescriptor(this.entityName);
        }
    }

    public ClassDescriptor getDescriptor() {
        this.checkDescriptorInitialized();
        return this.descriptor;
    }

    @Override
    public Object createObject() {
        this.checkDescriptorInitialized();
        return this.descriptor.createObject();
    }

    @Override
    public Property getDeclaredProperty(String propertyName) {
        this.checkDescriptorInitialized();
        return this.descriptor.getDeclaredProperty(propertyName);
    }

    @Override
    public ObjEntity getEntity() {
        this.checkDescriptorInitialized();
        return this.descriptor.getEntity();
    }

    @Override
    public Collection<DbEntity> getRootDbEntities() {
        this.checkDescriptorInitialized();
        return this.descriptor.getRootDbEntities();
    }

    @Override
    public EntityInheritanceTree getEntityInheritanceTree() {
        this.checkDescriptorInitialized();
        return this.descriptor.getEntityInheritanceTree();
    }

    @Override
    public boolean hasSubclasses() {
        this.checkDescriptorInitialized();
        return this.descriptor.hasSubclasses();
    }

    @Override
    public Class<?> getObjectClass() {
        ObjEntity entity;
        if (this.descriptor == null && (entity = this.descriptorMap.getResolver().getObjEntity(this.entityName)) != null) {
            return entity.getJavaClass();
        }
        this.checkDescriptorInitialized();
        return this.descriptor.getObjectClass();
    }

    @Override
    public Collection<AttributeProperty> getIdProperties() {
        this.checkDescriptorInitialized();
        return this.descriptor.getIdProperties();
    }

    @Override
    public Collection<ObjAttribute> getDiscriminatorColumns() {
        this.checkDescriptorInitialized();
        return this.descriptor.getDiscriminatorColumns();
    }

    @Override
    public Expression getEntityQualifier() {
        this.checkDescriptorInitialized();
        return this.descriptor.getEntityQualifier();
    }

    @Override
    public Collection<ArcProperty> getMapArcProperties() {
        this.checkDescriptorInitialized();
        return this.descriptor.getMapArcProperties();
    }

    @Override
    public Property getProperty(String propertyName) {
        this.checkDescriptorInitialized();
        return this.descriptor.getProperty(propertyName);
    }

    @Override
    public ClassDescriptor getSubclassDescriptor(Class<?> objectClass) {
        this.checkDescriptorInitialized();
        return this.descriptor.getSubclassDescriptor(objectClass);
    }

    @Override
    public ClassDescriptor getSuperclassDescriptor() {
        this.checkDescriptorInitialized();
        return this.descriptor.getSuperclassDescriptor();
    }

    @Override
    public void injectValueHolders(Object object) throws PropertyException {
        this.checkDescriptorInitialized();
        this.descriptor.injectValueHolders(object);
    }

    @Override
    public boolean isFault(Object object) {
        this.checkDescriptorInitialized();
        return this.descriptor.isFault(object);
    }

    @Override
    public void shallowMerge(Object from, Object to) throws PropertyException {
        this.checkDescriptorInitialized();
        this.descriptor.shallowMerge(from, to);
    }

    @Override
    public boolean visitDeclaredProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitDeclaredProperties(visitor);
    }

    @Override
    public boolean visitProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitProperties(visitor);
    }

    @Override
    public boolean visitAllProperties(PropertyVisitor visitor) {
        this.checkDescriptorInitialized();
        return this.descriptor.visitAllProperties(visitor);
    }
}

