/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.dialog.FindDialog;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.query.Query;

public class FindAction
extends CayenneAction {
    private List<Object> paths;

    public static String getActionName() {
        return "Find";
    }

    public FindAction(Application application) {
        super(FindAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        JTextField source = (JTextField)e.getSource();
        this.paths = new ArrayList<Object>();
        if (!source.getText().trim().equals("")) {
            Pattern pattern = Pattern.compile(source.getText().trim(), 2);
            for (DataMap dm : ((DataChannelDescriptor)this.getProjectController().getProject().getRootNode()).getDataMaps()) {
                for (Query q : dm.getQueries()) {
                    if (!this.matchFound(q.getName(), pattern)) continue;
                    this.paths.add(q);
                }
                for (Embeddable emb : dm.getEmbeddables()) {
                    if (this.matchFound(emb.getClassName(), pattern)) {
                        this.paths.add(emb);
                    }
                    for (EmbeddableAttribute attr : emb.getAttributes()) {
                        if (!this.matchFound(attr.getName(), pattern)) continue;
                        this.paths.add(attr);
                    }
                }
                for (DbEntity ent : dm.getDbEntities()) {
                    if (this.matchFound(ent.getName(), pattern)) {
                        this.paths.add(ent);
                    }
                    for (DbAttribute attr : ent.getAttributes()) {
                        if (!this.matchFound(attr.getName(), pattern)) continue;
                        this.paths.add(attr);
                    }
                    for (DbRelationship rel : ent.getRelationships()) {
                        if (!this.matchFound(rel.getName(), pattern)) continue;
                        this.paths.add(rel);
                    }
                }
                for (ObjEntity ent : dm.getObjEntities()) {
                    if (this.matchFound(ent.getName(), pattern)) {
                        this.paths.add(ent);
                    }
                    for (ObjAttribute attr : ent.getAttributes()) {
                        if (!this.matchFound(attr.getName(), pattern)) continue;
                        this.paths.add(attr);
                    }
                    for (ObjRelationship rel : ent.getRelationships()) {
                        if (!this.matchFound(rel.getName(), pattern)) continue;
                        this.paths.add(rel);
                    }
                }
            }
        }
        if (this.paths.size() == 0) {
            source.setBackground(Color.pink);
        } else if (this.paths.size() != 1) {
            new FindDialog(this.getApplication().getFrameController(), this.paths).startupAction();
        } else {
            Iterator<Object> it = this.paths.iterator();
            boolean index = false;
            if (it.hasNext()) {
                Object path = it.next();
                FindDialog.jumpToResult(path);
            }
        }
    }

    private boolean matchFound(String entityName, Pattern pattern) {
        Matcher m = pattern.matcher(entityName);
        return m.find();
    }
}

