/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.util.NameConverter;

public class BasicNamingStrategy
implements NamingStrategy {
    public String createDbRelationshipName(ExportedKey key, boolean toMany) {
        String uglyName = toMany ? key.getFKTableName() + "_ARRAY" : "to_" + key.getPKTableName();
        return NameConverter.underscoredToJava(uglyName, false);
    }

    public String createObjEntityName(DbEntity dbEntity) {
        return NameConverter.underscoredToJava(dbEntity.getName(), true);
    }

    public String createObjAttributeName(DbAttribute attr) {
        return NameConverter.underscoredToJava(attr.getName(), false);
    }

    public String createObjRelationshipName(DbRelationship dbRel) {
        return NameConverter.underscoredToJava(dbRel.getName(), false);
    }
}

