/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.audit;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.lifecycle.changeset.ChangeSet;
import org.apache.cayenne.lifecycle.changeset.ChangeSetFilter;
import org.apache.cayenne.lifecycle.changeset.PropertyChange;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;

class AuditableEntityDescriptor {
    private Collection<String> ignoredProperties = new HashSet<String>();

    AuditableEntityDescriptor(ObjEntity auditableEntity, String[] ignoredProperties) {
        for (ObjRelationship relationship : auditableEntity.getRelationships()) {
            if (!relationship.isRuntime()) continue;
            this.ignoredProperties.add(relationship.getName());
        }
        if (ignoredProperties != null) {
            for (String property : ignoredProperties) {
                this.ignoredProperties.add(property);
            }
        }
    }

    boolean auditableChange(Persistent object) {
        if (this.ignoredProperties.isEmpty()) {
            return true;
        }
        ChangeSet changeSet = ChangeSetFilter.preCommitChangeSet();
        if (changeSet == null) {
            throw new CayenneRuntimeException("Required ChangeSetFilter is not installed, or is in the wrong place in the filter chain.", new Object[0]);
        }
        Map<String, PropertyChange> changes = changeSet.getChanges(object);
        if (changes.size() > this.ignoredProperties.size()) {
            return true;
        }
        for (String key : changes.keySet()) {
            if (this.ignoredProperties.contains(key)) continue;
            return true;
        }
        return false;
    }
}

