/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMTokenSelector
implements TokenSelector<NMTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(NMTokenSelector.class);

    @Override
    public Token<NMTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Looking for service: {}. Current token is {}", (Object)service, (Object)token);
            if (!NMTokenIdentifier.KIND.equals(token.getKind()) || !service.equals(token.getService())) continue;
            return token;
        }
        return null;
    }
}

