/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.LockServiceImpl;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;

abstract class BaseLockOperation
extends AbstractOperation
implements PartitionAwareOperation {
    public static final long DEFAULT_LOCK_TTL = Long.MAX_VALUE;
    protected ObjectNamespace namespace;
    protected Data key;
    protected int threadId;
    protected long ttl = Long.MAX_VALUE;
    protected long timeout = -1L;
    protected transient Object response;
    private transient boolean asyncBackup = false;

    public BaseLockOperation() {
    }

    protected BaseLockOperation(ObjectNamespace namespace, Data key, int threadId) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
    }

    protected BaseLockOperation(ObjectNamespace namespace, Data key, int threadId, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.timeout = timeout;
    }

    public BaseLockOperation(ObjectNamespace namespace, Data key, int threadId, long ttl, long timeout) {
        this.namespace = namespace;
        this.key = key;
        this.threadId = threadId;
        this.ttl = ttl;
        this.timeout = timeout;
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    protected final LockStoreImpl getLockStore() {
        LockServiceImpl service = (LockServiceImpl)this.getService();
        return service.getLockStore(this.getPartitionId(), this.namespace);
    }

    public final int getSyncBackupCount() {
        return !this.asyncBackup ? this.getLockStore().getBackupCount() : 0;
    }

    public final int getAsyncBackupCount() {
        LockStoreImpl lockStore = this.getLockStore();
        return !this.asyncBackup ? lockStore.getAsyncBackupCount() : lockStore.getBackupCount() + lockStore.getAsyncBackupCount();
    }

    public final void setAsyncBackup(boolean asyncBackup) {
        this.asyncBackup = asyncBackup;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    public final Data getKey() {
        return this.key;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.namespace);
        this.key.writeData(out);
        out.writeInt(this.threadId);
        out.writeLong(this.ttl);
        out.writeLong(this.timeout);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.namespace = (ObjectNamespace)in.readObject();
        this.key = new Data();
        this.key.readData(in);
        this.threadId = in.readInt();
        this.ttl = in.readLong();
        this.timeout = in.readLong();
    }
}

