/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task.utils.bes;

import java.util.List;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.impl.task.utils.bes.JSDLUtils;
import org.apache.airavata.gfac.impl.task.utils.bes.SPMDVariations;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.parallelism.ApplicationParallelismType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.FileNameType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.UserNameType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.NumberOfProcessesType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.ProcessesPerHostType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.ThreadsPerProcessType;

public class ApplicationProcessor {
    public static void generateJobSpecificAppElements(JobDefinitionType value, ProcessContext context) {
        String userName = ApplicationProcessor.getUserNameFromContext(context);
        ApplicationDeploymentDescription appDep = context.getApplicationDeploymentDescription();
        String appname = context.getApplicationInterfaceDescription().getApplicationName();
        ApplicationParallelismType parallelism = appDep.getParallelism();
        ApplicationType appType = JSDLUtils.getOrCreateApplication(value);
        appType.setApplicationName(appname);
        String stdout = context.getStdoutLocation();
        String stderr = context.getStderrLocation();
        if (stdout != null) {
            stdout = stdout.substring(stdout.lastIndexOf(47) + 1);
        }
        if (stderr != null) {
            stderr = stderr.substring(stderr.lastIndexOf(47) + 1);
        }
        stdout = stdout == null || stdout.equals("") ? "stdout" : stdout;
        String string = stderr = stdout == null || stderr.equals("") ? "stderr" : stderr;
        if (appDep.getExecutablePath() != null) {
            FileNameType fNameType = FileNameType.Factory.newInstance();
            fNameType.setStringValue(appDep.getExecutablePath());
            if (ApplicationProcessor.isParallelJob(context)) {
                FileNameType fName;
                JSDLUtils.getOrCreateSPMDApplication(value).setExecutable(fNameType);
                if (parallelism.equals((Object)ApplicationParallelismType.OPENMP_MPI)) {
                    JSDLUtils.getSPMDApplication(value).setSPMDVariation(SPMDVariations.OpenMPI.value());
                } else if (parallelism.equals((Object)ApplicationParallelismType.MPI)) {
                    JSDLUtils.getSPMDApplication(value).setSPMDVariation(SPMDVariations.MPI.value());
                }
                try {
                    String np = ApplicationProcessor.getInputAsString(context, "NumberOfProcesses");
                    if (np != null && Integer.parseInt(np) > 0) {
                        NumberOfProcessesType num = NumberOfProcessesType.Factory.newInstance();
                        num.setStringValue(np);
                        JSDLUtils.getSPMDApplication(value).setNumberOfProcesses(num);
                    }
                }
                catch (RuntimeException np) {
                    // empty catch block
                }
                try {
                    String pphost = ApplicationProcessor.getInputAsString(context, "ProcessesPerHost");
                    if (pphost != null && Integer.parseInt(pphost) > 0) {
                        ProcessesPerHostType pph = ProcessesPerHostType.Factory.newInstance();
                        pph.setStringValue(String.valueOf(pphost));
                        JSDLUtils.getSPMDApplication(value).setProcessesPerHost(pph);
                    }
                }
                catch (RuntimeException pphost) {
                    // empty catch block
                }
                int totalThreadCount = context.getProcessModel().getProcessResourceSchedule().getNumberOfThreads();
                if (totalThreadCount > 0) {
                    ThreadsPerProcessType tpp = ThreadsPerProcessType.Factory.newInstance();
                    tpp.setStringValue(String.valueOf(totalThreadCount));
                    JSDLUtils.getSPMDApplication(value).setThreadsPerProcess(tpp);
                }
                if (userName != null) {
                    UserNameType userNameType = UserNameType.Factory.newInstance();
                    userNameType.setStringValue(userName);
                    JSDLUtils.getSPMDApplication(value).setUserName(userNameType);
                }
                if (stdout != null) {
                    fName = FileNameType.Factory.newInstance();
                    fName.setStringValue(stdout);
                    JSDLUtils.getOrCreateSPMDApplication(value).setOutput(fName);
                }
                if (stderr != null) {
                    fName = FileNameType.Factory.newInstance();
                    fName.setStringValue(stderr);
                    JSDLUtils.getOrCreateSPMDApplication(value).setError(fName);
                }
            } else {
                FileNameType fName;
                JSDLUtils.getOrCreatePOSIXApplication(value).setExecutable(fNameType);
                if (userName != null) {
                    UserNameType userNameType = UserNameType.Factory.newInstance();
                    userNameType.setStringValue(userName);
                    JSDLUtils.getOrCreatePOSIXApplication(value).setUserName(userNameType);
                }
                if (stdout != null) {
                    fName = FileNameType.Factory.newInstance();
                    fName.setStringValue(stdout);
                    JSDLUtils.getOrCreatePOSIXApplication(value).setOutput(fName);
                }
                if (stderr != null) {
                    fName = FileNameType.Factory.newInstance();
                    fName.setStringValue(stderr);
                    JSDLUtils.getOrCreatePOSIXApplication(value).setError(fName);
                }
            }
        }
    }

    public static String getUserNameFromContext(ProcessContext jobContext) {
        if (jobContext.getProcessModel() == null) {
            return null;
        }
        return "admin";
    }

    public static void addApplicationArgument(JobDefinitionType value, ProcessContext context, String stringPrm) {
        if (ApplicationProcessor.isParallelJob(context)) {
            JSDLUtils.getOrCreateSPMDApplication(value).addNewArgument().setStringValue(stringPrm);
        } else {
            JSDLUtils.getOrCreatePOSIXApplication(value).addNewArgument().setStringValue(stringPrm);
        }
    }

    public static String getApplicationStdOut(JobDefinitionType value, ProcessContext context) throws RuntimeException {
        if (ApplicationProcessor.isParallelJob(context)) {
            return JSDLUtils.getOrCreateSPMDApplication(value).getOutput().getStringValue();
        }
        return JSDLUtils.getOrCreatePOSIXApplication(value).getOutput().getStringValue();
    }

    public static String getApplicationStdErr(JobDefinitionType value, ProcessContext context) throws RuntimeException {
        if (ApplicationProcessor.isParallelJob(context)) {
            return JSDLUtils.getOrCreateSPMDApplication(value).getError().getStringValue();
        }
        return JSDLUtils.getOrCreatePOSIXApplication(value).getError().getStringValue();
    }

    public static void createGenericApplication(JobDefinitionType value, String appName) {
        ApplicationType appType = JSDLUtils.getOrCreateApplication(value);
        appType.setApplicationName(appName);
    }

    public static boolean isParallelJob(ProcessContext context) {
        ApplicationDeploymentDescription appDep = context.getApplicationDeploymentDescription();
        ApplicationParallelismType parallelism = appDep.getParallelism();
        boolean isParallel = false;
        if (parallelism.equals((Object)ApplicationParallelismType.MPI) || parallelism.equals((Object)ApplicationParallelismType.OPENMP_MPI) || parallelism.equals((Object)ApplicationParallelismType.OPENMP)) {
            isParallel = true;
        }
        return isParallel;
    }

    private static String getInputAsString(ProcessContext context, String name) {
        List inputList = context.getProcessModel().getProcessInputs();
        String value = null;
        for (InputDataObjectType inputDataObjectType : inputList) {
            if (!inputDataObjectType.getName().equals(name)) continue;
            value = inputDataObjectType.getValue();
            break;
        }
        return value;
    }
}

