/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl;

import com.jcraft.jsch.Channel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.airavata.gfac.core.cluster.CommandOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOutReader
implements CommandOutput {
    private static final Logger logger = LoggerFactory.getLogger(StandardOutReader.class);
    String stdOutputString = null;
    ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
    private int exitCode;

    public void onOutput(Channel channel) {
        try {
            StringBuffer pbsOutput = new StringBuffer("");
            InputStream inputStream = channel.getInputStream();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (inputStream.available() > 0 && (i = inputStream.read(tmp, 0, 1024)) >= 0) {
                    pbsOutput.append(new String(tmp, 0, i));
                    continue;
                }
                if (channel.isClosed()) break;
            }
            String output = pbsOutput.toString();
            this.setStdOutputString(output);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void exitCode(int code) {
        System.out.println("Program exit code - " + code);
        this.exitCode = code;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getStdOutputString() {
        return this.stdOutputString;
    }

    public void setStdOutputString(String stdOutputString) {
        this.stdOutputString = stdOutputString;
    }

    public String getStdErrorString() {
        return this.errorStream.toString();
    }

    public OutputStream getStandardError() {
        return this.errorStream;
    }
}

