/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class AddInstanceGroupsRequestMarshaller
implements Marshaller<Request<AddInstanceGroupsRequest>, AddInstanceGroupsRequest> {
    public Request<AddInstanceGroupsRequest> marshall(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        if (addInstanceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addInstanceGroupsRequest, "AmazonElasticMapReduce");
        String target = "ElasticMapReduce.AddInstanceGroups";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag instanceGroupsList = (ListWithAutoConstructFlag)addInstanceGroupsRequest.getInstanceGroups();
            if (!(instanceGroupsList == null || instanceGroupsList.isAutoConstruct() && instanceGroupsList.isEmpty())) {
                jsonWriter.key("InstanceGroups");
                jsonWriter.array();
                for (InstanceGroupConfig instanceGroupsListValue : instanceGroupsList) {
                    if (instanceGroupsListValue == null) continue;
                    jsonWriter.object();
                    if (instanceGroupsListValue.getName() != null) {
                        jsonWriter.key("Name").value((Object)instanceGroupsListValue.getName());
                    }
                    if (instanceGroupsListValue.getMarket() != null) {
                        jsonWriter.key("Market").value((Object)instanceGroupsListValue.getMarket());
                    }
                    if (instanceGroupsListValue.getInstanceRole() != null) {
                        jsonWriter.key("InstanceRole").value((Object)instanceGroupsListValue.getInstanceRole());
                    }
                    if (instanceGroupsListValue.getBidPrice() != null) {
                        jsonWriter.key("BidPrice").value((Object)instanceGroupsListValue.getBidPrice());
                    }
                    if (instanceGroupsListValue.getInstanceType() != null) {
                        jsonWriter.key("InstanceType").value((Object)instanceGroupsListValue.getInstanceType());
                    }
                    if (instanceGroupsListValue.getInstanceCount() != null) {
                        jsonWriter.key("InstanceCount").value((Object)instanceGroupsListValue.getInstanceCount());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (addInstanceGroupsRequest.getJobFlowId() != null) {
                jsonWriter.key("JobFlowId").value((Object)addInstanceGroupsRequest.getJobFlowId());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

