/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.airavata.sharing.registry.server.SharingRegistryServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.management.VMManagement;

public class ServerMain {
    private static final Logger logger = LoggerFactory.getLogger(ServerMain.class);
    private static int serverPID = -1;
    private static final String stopFileNamePrefix = "server_stop";
    private static final String serverStartedFileNamePrefix = "server_start";

    public static void main(String[] args) {
        try {
            ServerMain.setServerStarted();
            new SharingRegistryServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void setServerStarted() {
        try {
            serverPID = ServerMain.getPID();
            ServerMain.deleteOldStopRequests();
            File serverStartedFile = null;
            serverStartedFile = new File(ServerMain.getServerStartedFileName());
            serverStartedFile.createNewFile();
            serverStartedFile.deleteOnExit();
            new RandomAccessFile(serverStartedFile, "rw").getChannel().lock();
        }
        catch (FileNotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    private static String getServerStartedFileName() {
        String SHARING_REGISTRY_HOME = System.getenv("SHARING_REGISTRY_HOME");
        SHARING_REGISTRY_HOME = SHARING_REGISTRY_HOME == null ? "/tmp" : SHARING_REGISTRY_HOME + "/bin";
        return new File(SHARING_REGISTRY_HOME, "server_start_" + Integer.toString(serverPID)).toString();
    }

    private static int getPID() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            VMManagement mgmt = (VMManagement)jvm.get(runtime);
            Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            int pid = (Integer)pid_method.invoke((Object)mgmt, new Object[0]);
            return pid;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static void deleteOldStopRequests() {
        File[] files;
        for (File file : files = new File(".").listFiles()) {
            if (!file.getName().contains(stopFileNamePrefix)) continue;
            file.delete();
        }
    }
}

