/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import javax.ws.rs.core.Response;
import org.apache.hadoop.hdfs.web.resources.EnumParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;

public abstract class HttpOpParam<E extends Enum<E>>
extends EnumParam<E> {
    public static final String NAME = "op";
    public static final String DEFAULT = "null";

    HttpOpParam(EnumParam.Domain<E> domain, E value) {
        super(domain, value);
    }

    public static class TemporaryRedirectOp
    implements Op {
        static final TemporaryRedirectOp CREATE = new TemporaryRedirectOp(PutOpParam.Op.CREATE);
        static final TemporaryRedirectOp APPEND = new TemporaryRedirectOp(PostOpParam.Op.APPEND);
        private final Op op;

        public static TemporaryRedirectOp valueOf(Op op) {
            if (op == TemporaryRedirectOp.CREATE.op) {
                return CREATE;
            }
            if (op == TemporaryRedirectOp.APPEND.op) {
                return APPEND;
            }
            throw new IllegalArgumentException(op + " not found.");
        }

        private TemporaryRedirectOp(Op op) {
            this.op = op;
        }

        @Override
        public Type getType() {
            return this.op.getType();
        }

        @Override
        public boolean getDoOutput() {
            return this.op.getDoOutput();
        }

        @Override
        public int getExpectedHttpResponseCode() {
            return Response.Status.TEMPORARY_REDIRECT.getStatusCode();
        }

        @Override
        public String toQueryString() {
            return this.op.toQueryString();
        }
    }

    public static interface Op {
        public Type getType();

        public boolean getDoOutput();

        public int getExpectedHttpResponseCode();

        public String toQueryString();
    }

    public static enum Type {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

