/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.store;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.store.AbstractDirectoryStore;
import org.compass.core.lucene.engine.store.CopyFromHolder;
import org.compass.core.lucene.util.LuceneUtils;

public class FSDirectoryStore
extends AbstractDirectoryStore
implements CompassConfigurable {
    private static final Log log = LogFactory.getLog(FSDirectoryStore.class);
    public static final String PROTOCOL = "file://";
    private String indexPath;

    public void configure(CompassSettings settings) throws CompassException {
        FSDirectory directory;
        String connection = settings.getSetting("compass.engine.connection");
        this.indexPath = this.findIndexPath(connection);
        System.setProperty("org.apache.lucene.FSDirectory.class", this.getFSDirectoryClass());
        try {
            directory = FSDirectory.getDirectory(System.getProperty("java.io.tmpdir"));
            directory.close();
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open the lucene directory", e);
        }
        if (!directory.getClass().getName().equals(this.getFSDirectoryClass())) {
            throw new SearchEngineException("Setting type of FS directory is a JVM level setting, you can not set different values within the same JVM");
        }
    }

    protected String findIndexPath(String connection) {
        if (connection.startsWith(PROTOCOL)) {
            return connection.substring(PROTOCOL.length());
        }
        return connection;
    }

    public Directory open(String subContext, String subIndex) throws SearchEngineException {
        try {
            return FSDirectory.getDirectory(this.buildPath(subContext, subIndex));
        }
        catch (IOException e) {
            throw new SearchEngineException("Failed to open directory for path [" + subIndex + "]", e);
        }
    }

    public void deleteIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        File indexPathFile = new File(this.buildPath(subContext, subIndex));
        if (indexPathFile.exists()) {
            boolean deleted = false;
            for (int i = 0; i < 10 && !(deleted = LuceneUtils.deleteDir(indexPathFile)); ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!deleted) {
                throw new SearchEngineException("Failed to delete index directory [" + this.buildPath(subContext, subIndex) + "]");
            }
        }
    }

    public void cleanIndex(Directory dir, String subContext, String subIndex) throws SearchEngineException {
        this.deleteIndex(dir, subContext, subIndex);
    }

    public CopyFromHolder beforeCopyFrom(String subContext, String subIndex, Directory dir) throws SearchEngineException {
        File renameToIndexPathFile;
        String path = this.buildPath(subContext, subIndex);
        File indexPathFile = new File(path);
        int count = 0;
        while ((renameToIndexPathFile = new File(path + "-copy" + count++)).exists()) {
        }
        boolean renamed = false;
        for (int i = 0; i < 10 && !(renamed = indexPathFile.renameTo(renameToIndexPathFile)); ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!renamed) {
            throw new SearchEngineException("Failed to rename index [" + path + "] to [" + renameToIndexPathFile.getPath() + "]");
        }
        ((FSDirectory)dir).getFile().mkdirs();
        CopyFromHolder holder = new CopyFromHolder();
        holder.data = renameToIndexPathFile;
        return holder;
    }

    public void afterSuccessfulCopyFrom(String subContext, String subIndex, CopyFromHolder holder) throws SearchEngineException {
        File renameToIndexPathFile = (File)holder.data;
        try {
            LuceneUtils.deleteDir(renameToIndexPathFile);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to delete backup directory", (Throwable)e);
        }
    }

    public void afterFailedCopyFrom(String subContext, CopyFromHolder holder) throws SearchEngineException {
    }

    protected String buildPath(String subContext, String subIndex) {
        return this.indexPath + "/" + subContext + "/" + subIndex;
    }

    public boolean suggestedUseCompoundFile() {
        return true;
    }

    protected String getFSDirectoryClass() {
        return "org.apache.lucene.store.FSDirectory";
    }
}

