/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.dpc;

import eu.unicore.uftp.dpc.DPCClient;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Reply {
    private int code;
    private final List<String> results = new ArrayList<String>();
    private String statusLine;

    private Reply() {
    }

    public int getCode() {
        return this.code;
    }

    public boolean isError() {
        return this.code >= 500;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public List<String> getResults() {
        return this.results;
    }

    public static Reply read(DPCClient client) throws IOException {
        boolean multiline;
        Reply r = new Reply();
        String reply = client.readControl();
        if (reply == null) {
            throw new ProtocolViolationException("Got unexpected null reply");
        }
        reply = reply.trim();
        String codeS = reply.substring(0, 3);
        r.code = Integer.parseInt(codeS);
        r.statusLine = reply;
        boolean bl = multiline = reply.length() > 3 && '-' == reply.charAt(3);
        if (multiline) {
            while ((reply = client.readControl()) != null && !reply.startsWith(String.valueOf(r.code))) {
                r.results.add(reply.trim());
            }
        }
        return r;
    }
}

