/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.security.wsutil.client.TDOutHandler;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;

public class ClientTrustDelegationUtil {
    public static void addTrustDelegation(Object cxfProxy, List<TrustDelegation> tdChain) {
        Client cxfClient = ClientProxy.getClient((Object)cxfProxy);
        ClientTrustDelegationUtil.addTrustDelegation(cxfClient, tdChain);
    }

    public static void addTrustDelegation(Client cxfClient, List<TrustDelegation> tdChain) {
        if (tdChain == null || tdChain.size() == 0) {
            throw new IllegalArgumentException("Trust delegation chain can't be null/empty");
        }
        TrustDelegation td1 = tdChain.get(0);
        TrustDelegation tdLast = tdChain.get(tdChain.size() - 1);
        ClientTrustDelegationUtil.addTrustDelegation(cxfClient, tdChain, td1.getIssuerFromSignature()[0], tdLast.getSubjectName());
    }

    public static void addTrustDelegation(Object cxfProxy, List<TrustDelegation> tdChain, X509Certificate user, String callerDN) {
        Client CXFClient = ClientProxy.getClient((Object)cxfProxy);
        ClientTrustDelegationUtil.addTrustDelegation(CXFClient, tdChain, user, callerDN);
    }

    public static void addTrustDelegation(Client cxfClient, List<TrustDelegation> tdChain, X509Certificate userCert, String callerDN) {
        ClientTrustDelegationUtil.addTrustDelegation(cxfClient, tdChain, userCert, null, callerDN);
    }

    public static void addTrustDelegation(Object cxfProxy, List<TrustDelegation> tdChain, String userDN, String callerDN) {
        Client CXFClient = ClientProxy.getClient((Object)cxfProxy);
        ClientTrustDelegationUtil.addTrustDelegation(CXFClient, tdChain, null, userDN, callerDN);
    }

    public static void addTrustDelegation(Client cxfClient, List<TrustDelegation> tdChain, String userDN, String callerDN) {
        ClientTrustDelegationUtil.addTrustDelegation(cxfClient, tdChain, null, userDN, callerDN);
    }

    private static void addTrustDelegation(Client cxfClient, List<TrustDelegation> tdChain, X509Certificate user, String userDN, String callerDN) {
        List outHandlers = cxfClient.getOutInterceptors();
        TDOutHandler tdHandler = null;
        for (Object h : outHandlers) {
            if (!(h instanceof TDOutHandler)) continue;
            tdHandler = (TDOutHandler)((Object)h);
            break;
        }
        if (tdHandler != null) {
            outHandlers.remove((Object)tdHandler);
        }
        tdHandler = userDN == null ? new TDOutHandler(tdChain, user, callerDN) : new TDOutHandler(tdChain, userDN, callerDN);
        cxfClient.getOutInterceptors().add(tdHandler);
    }

    public static void removeTrustDelegation(Object cxfProxy) {
        Client CXFClient = ClientProxy.getClient((Object)cxfProxy);
        ClientTrustDelegationUtil.removeTrustDelegation(CXFClient);
    }

    public static void removeTrustDelegation(Client cxfClient) {
        List outHandlers = cxfClient.getOutInterceptors();
        for (int i = outHandlers.size() - 1; i >= 0; --i) {
            Object h = outHandlers.get(i);
            if (!(h instanceof TDOutHandler)) continue;
            outHandlers.remove(i);
        }
    }
}

