/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.exceptions.SAMLValidationException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.protocol.StatusCodeType;
import xmlbeans.org.oasis.saml2.protocol.StatusResponseType;
import xmlbeans.org.oasis.saml2.protocol.StatusType;

public class StatusResponseValidator {
    protected String consumerEndpointUri;
    protected String requestId;
    protected SamlTrustChecker trustChecker;

    public StatusResponseValidator(String consumerEndpointUri, String requestId, SamlTrustChecker trustChecker) {
        this.consumerEndpointUri = consumerEndpointUri;
        this.requestId = requestId;
        if (trustChecker == null) {
            throw new IllegalArgumentException("The SAMLTrustChecker can not be null");
        }
        this.trustChecker = trustChecker;
    }

    public void validate(XmlObject wrappingDcoument, StatusResponseType responseXml) throws SAMLValidationException {
        this.checkMandatoryElements(responseXml);
        String inResponseTo = responseXml.getInResponseTo();
        if (this.requestId != null && inResponseTo != null && !inResponseTo.equals(this.requestId)) {
            throw new SAMLValidationException("InResponseTo value " + inResponseTo + " is not matching expected requestId: " + this.requestId);
        }
        String destination = responseXml.getDestination();
        if (destination != null && this.consumerEndpointUri != null && !destination.equals(this.consumerEndpointUri)) {
            throw new SAMLValidationException("Destination value " + destination + " is not matching consumer URI: " + this.consumerEndpointUri);
        }
        this.checkStatus(responseXml);
        if (responseXml.getSignature() != null && !responseXml.getSignature().isNil()) {
            this.trustChecker.checkTrust(wrappingDcoument, responseXml);
        }
    }

    protected void checkMandatoryElements(StatusResponseType responseXml) throws SAMLValidationException {
        if (responseXml.getID() == null || responseXml.getID().equals("")) {
            throw new SAMLValidationException("Response must posses an ID");
        }
        if (responseXml.getVersion() == null || !responseXml.getVersion().equals("2.0")) {
            throw new SAMLValidationException("Response must posses 2.0 version");
        }
        if (responseXml.getIssueInstant() == null) {
            throw new SAMLValidationException("Response must posses an IssueInstant");
        }
        if (responseXml.getStatus() == null || responseXml.getStatus().isNil()) {
            throw new SAMLValidationException("Response must have a status set");
        }
    }

    protected void checkStatus(StatusResponseType responseXml) throws SAMLValidationException {
        StatusType status = responseXml.getStatus();
        if (status.getStatusCode() == null || status.getStatusCode().isNil()) {
            throw new SAMLValidationException("Response must have status code set");
        }
        String statusValue = status.getStatusCode().getValue();
        if (statusValue == null) {
            throw new SAMLValidationException("Response must have status code's value set");
        }
        if (statusValue.equals(SAMLConstants.Status.STATUS_OK.toString())) {
            return;
        }
        if (!(statusValue.equals(SAMLConstants.Status.STATUS_REQUESTER.toString()) || statusValue.equals(SAMLConstants.Status.STATUS_RESPONDER.toString()) || statusValue.equals(SAMLConstants.Status.STATUS_VERSION_MISMATCH.toString()))) {
            throw new SAMLValidationException("Response has illegal status value: " + statusValue);
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Got error in the response. Caused by ");
        msg.append(statusValue.substring(statusValue.lastIndexOf(":") + 1));
        StatusCodeType subCode = status.getStatusCode().getStatusCode();
        if (subCode != null && subCode.getValue() != null) {
            String value = subCode.getValue();
            if (value.startsWith("urn:oasis:names:tc:SAML:2.0:status:")) {
                value = value.substring("urn:oasis:names:tc:SAML:2.0:status:".length());
            }
            msg.append(" Error type: " + value);
        }
        if (status.getStatusMessage() != null) {
            msg.append(" Message: " + status.getStatusMessage());
        }
        if (subCode != null && subCode.getValue() != null) {
            throw new SAMLServerException(SAMLConstants.Status.fromString(statusValue), SAMLConstants.SubStatus.fromString(subCode.getValue()), msg.toString());
        }
        throw new SAMLServerException(SAMLConstants.Status.fromString(statusValue), msg.toString());
    }
}

