/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;

@Internal
public class LFOData {
    private int _cp;
    private ListFormatOverrideLevel[] _rgLfoLvl;

    public LFOData() {
        this._cp = 0;
        this._rgLfoLvl = new ListFormatOverrideLevel[0];
    }

    LFOData(byte[] buf, int startOffset, int cLfolvl) {
        int offset = startOffset;
        this._cp = LittleEndian.getInt(buf, offset);
        offset += 4;
        this._rgLfoLvl = new ListFormatOverrideLevel[cLfolvl];
        for (int x = 0; x < cLfolvl; ++x) {
            this._rgLfoLvl[x] = new ListFormatOverrideLevel(buf, offset);
            offset += this._rgLfoLvl[x].getSizeInBytes();
        }
    }

    public int getCp() {
        return this._cp;
    }

    public ListFormatOverrideLevel[] getRgLfoLvl() {
        return this._rgLfoLvl;
    }

    public int getSizeInBytes() {
        int result = 0;
        result += 4;
        for (ListFormatOverrideLevel lfolvl : this._rgLfoLvl) {
            result += lfolvl.getSizeInBytes();
        }
        return result;
    }

    void writeTo(HWPFOutputStream tableStream) throws IOException {
        LittleEndian.putInt(this._cp, tableStream);
        for (ListFormatOverrideLevel lfolvl : this._rgLfoLvl) {
            tableStream.write(lfolvl.toByteArray());
        }
    }
}

