/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class EventData
implements DataSerializable {
    protected String source;
    protected String mapName;
    protected Address caller;
    protected Data dataKey;
    protected Data dataNewValue;
    protected Data dataOldValue;
    protected int eventType;

    public EventData() {
    }

    public EventData(String source, String mapName, Address caller, Data dataKey, Data dataNewValue, Data dataOldValue, int eventType) {
        this.source = source;
        this.mapName = mapName;
        this.caller = caller;
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
        this.eventType = eventType;
    }

    public String getSource() {
        return this.source;
    }

    public String getMapName() {
        return this.mapName;
    }

    public Address getCaller() {
        return this.caller;
    }

    public Data getDataKey() {
        return this.dataKey;
    }

    public Data getDataNewValue() {
        return this.dataNewValue;
    }

    public Data getDataOldValue() {
        return this.dataOldValue;
    }

    public int getEventType() {
        return this.eventType;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.source);
        out.writeUTF(this.mapName);
        out.writeObject(this.caller);
        this.dataKey.writeData(out);
        IOUtil.writeNullableData(out, this.dataNewValue);
        IOUtil.writeNullableData(out, this.dataOldValue);
        out.writeInt(this.eventType);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.source = in.readUTF();
        this.mapName = in.readUTF();
        this.caller = (Address)in.readObject();
        this.dataKey = IOUtil.readData(in);
        this.dataNewValue = IOUtil.readNullableData(in);
        this.dataOldValue = IOUtil.readNullableData(in);
        this.eventType = in.readInt();
    }

    public Object cloneWithoutValues() {
        return new EventData(this.source, this.mapName, this.caller, this.dataKey, null, null, this.eventType);
    }
}

