/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectionPartitionContainer {
    final int partitionId;
    final CollectionService service;
    final ConcurrentMap<CollectionProxyId, CollectionContainer> containerMap = new ConcurrentHashMap<CollectionProxyId, CollectionContainer>(1000);
    private final ConstructorFunction<CollectionProxyId, CollectionContainer> collectionConstructor = new ConstructorFunction<CollectionProxyId, CollectionContainer>(){

        @Override
        public CollectionContainer createNew(CollectionProxyId proxyId) {
            return new CollectionContainer(proxyId, CollectionPartitionContainer.this.service, CollectionPartitionContainer.this.partitionId);
        }
    };

    public CollectionPartitionContainer(CollectionService service, int partitionId) {
        this.service = service;
        this.partitionId = partitionId;
    }

    public CollectionContainer getOrCreateCollectionContainer(CollectionProxyId proxyId) {
        CollectionContainer container = ConcurrencyUtil.getOrPutIfAbsent(this.containerMap, proxyId, this.collectionConstructor);
        container.access();
        return container;
    }

    public CollectionContainer getCollectionContainer(CollectionProxyId proxyId) {
        CollectionContainer container = (CollectionContainer)this.containerMap.get(proxyId);
        if (container != null) {
            container.access();
        }
        return container;
    }

    void destroyCollection(CollectionProxyId collectionProxyId) {
        CollectionContainer container = (CollectionContainer)this.containerMap.remove(collectionProxyId);
        if (container != null) {
            container.destroy();
        }
    }

    void destroy() {
        for (CollectionContainer container : this.containerMap.values()) {
            container.destroy();
        }
        this.containerMap.clear();
    }
}

