/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.StorageService;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.ProgressMonitoredInputStream;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.multi.StorageServiceEventAdaptor;
import org.jets3t.service.multi.StorageServiceEventListener;
import org.jets3t.service.multi.ThreadedStorageService;
import org.jets3t.service.multi.event.GetObjectHeadsEvent;
import org.jets3t.service.multi.event.ListObjectsEvent;
import org.jets3t.service.utils.FileComparerResults;
import org.jets3t.service.utils.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComparer {
    private static final Log log = LogFactory.getLog(FileComparer.class);
    private Jets3tProperties jets3tProperties = null;

    public FileComparer(Jets3tProperties jets3tProperties) {
        this.jets3tProperties = jets3tProperties;
    }

    public static FileComparer getInstance(Jets3tProperties jets3tProperties) {
        return new FileComparer(jets3tProperties);
    }

    public static FileComparer getInstance() {
        return new FileComparer(Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected List<Pattern> buildIgnoreRegexpList(File directory, List<Pattern> parentIgnorePatternList) {
        ArrayList<Pattern> ignorePatternList;
        block12: {
            ignorePatternList = new ArrayList<Pattern>();
            if (parentIgnorePatternList != null) {
                for (Pattern parentPattern : parentIgnorePatternList) {
                    String parentIgnorePatternString = parentPattern.pattern();
                    int slashOffset = parentIgnorePatternString.indexOf(Constants.FILE_PATH_DELIM);
                    if (slashOffset < 0 || parentIgnorePatternString.length() <= slashOffset + 1) continue;
                    String patternHeader = parentIgnorePatternString.substring(0, slashOffset);
                    String patternTail = parentIgnorePatternString.substring(slashOffset + 1);
                    if (".*.*".equals(patternHeader)) {
                        ignorePatternList.add(Pattern.compile(patternTail));
                        ignorePatternList.add(parentPattern);
                        continue;
                    }
                    if (!Pattern.compile(patternHeader).matcher(directory.getName()).matches()) continue;
                    ignorePatternList.add(Pattern.compile(patternTail));
                }
            }
            if (directory == null || !directory.isDirectory()) {
                return ignorePatternList;
            }
            File jets3tIgnoreFile = new File(directory, Constants.JETS3T_IGNORE_FILENAME);
            if (jets3tIgnoreFile.exists() && jets3tIgnoreFile.canRead()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found ignore file: " + jets3tIgnoreFile.getPath()));
                }
                try {
                    String ignorePaths = ServiceUtils.readInputStreamToString(new FileInputStream(jets3tIgnoreFile), null);
                    StringTokenizer st = new StringTokenizer(ignorePaths.trim(), "\n");
                    while (st.hasMoreTokens()) {
                        String ignorePath;
                        String ignoreRegexp = ignorePath = st.nextToken();
                        ignoreRegexp = ignoreRegexp.replaceAll("\\.", "\\\\.");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\*", ".*");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\?", ".");
                        Pattern pattern = Pattern.compile(ignoreRegexp);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Ignore path '" + ignorePath + "' has become the regexp: " + pattern.pattern()));
                        }
                        ignorePatternList.add(pattern);
                        if (!pattern.pattern().startsWith(".*.*/") || pattern.pattern().length() <= 5) continue;
                        ignorePatternList.add(Pattern.compile(pattern.pattern().substring(5)));
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)("Failed to read contents of ignore file '" + jets3tIgnoreFile.getPath() + "'"), (Throwable)e);
                }
            }
        }
        if (this.jets3tProperties.getBoolProperty("filecomparer.skip-upload-of-md5-files", false)) {
            Pattern pattern = Pattern.compile(".*\\.md5");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping upload of pre-computed MD5 files with path '*.md5' using the regexp: " + pattern.pattern()));
            }
            ignorePatternList.add(pattern);
        }
        return ignorePatternList;
    }

    protected boolean isIgnored(List<Pattern> ignorePatternList, File file) {
        if (this.jets3tProperties.getBoolProperty("filecomparer.skip-symlinks", false)) {
            try {
                if (!file.getAbsolutePath().equals(file.getCanonicalPath())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Ignoring symlink " + (file.isDirectory() ? "directory" : "file") + ": " + file.getName()));
                    }
                    return true;
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to determine whether " + (file.isDirectory() ? "directory" : "file") + " '" + file.getAbsolutePath() + "' is a symlink"), (Throwable)e);
            }
        }
        for (Pattern pattern : ignorePatternList) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ignoring " + (file.isDirectory() ? "directory" : "file") + " matching pattern '" + pattern.pattern() + "': " + file.getName()));
            }
            return true;
        }
        return false;
    }

    protected String normalizeUnicode(String str) {
        Normalizer.Form form = Normalizer.Form.NFD;
        if (!Normalizer.isNormalized(str, form)) {
            return Normalizer.normalize(str, form);
        }
        return str;
    }

    public Map<String, File> buildFileMap(File[] files, boolean includeDirectories) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        List<Pattern> ignorePatternList = null;
        List<Pattern> ignorePatternListForCurrentDir = null;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.getParentFile() == null) {
                if (ignorePatternListForCurrentDir == null) {
                    ignorePatternListForCurrentDir = this.buildIgnoreRegexpList(new File("."), null);
                }
                ignorePatternList = ignorePatternListForCurrentDir;
            } else {
                ignorePatternList = this.buildIgnoreRegexpList(file.getParentFile(), null);
            }
            if (this.isIgnored(ignorePatternList, file) || !file.exists()) continue;
            if (!file.isDirectory()) {
                fileMap.put(this.normalizeUnicode(file.getName()), file);
            }
            if (!file.isDirectory() || !includeDirectories) continue;
            String fileName = this.normalizeUnicode(file.getName() + Constants.FILE_PATH_DELIM);
            fileMap.put(fileName, file);
            this.buildFileMapImpl(file, fileName, fileMap, includeDirectories, ignorePatternList);
        }
        return fileMap;
    }

    public Map<String, File> buildFileMap(File rootDirectory, String fileKeyPrefix, boolean includeDirectories) {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        List<Pattern> ignorePatternList = this.buildIgnoreRegexpList(rootDirectory, null);
        if (!this.isIgnored(ignorePatternList, rootDirectory)) {
            if (fileKeyPrefix == null || fileKeyPrefix.length() == 0) {
                fileKeyPrefix = "";
            } else if (!fileKeyPrefix.endsWith(Constants.FILE_PATH_DELIM)) {
                fileKeyPrefix = fileKeyPrefix + Constants.FILE_PATH_DELIM;
            }
            this.buildFileMapImpl(rootDirectory, fileKeyPrefix, fileMap, includeDirectories, ignorePatternList);
        }
        return fileMap;
    }

    protected void buildFileMapImpl(File directory, String fileKeyPrefix, Map<String, File> fileMap, boolean includeDirectories, List<Pattern> parentIgnorePatternList) {
        List<Pattern> ignorePatternList = this.buildIgnoreRegexpList(directory, parentIgnorePatternList);
        File[] children = directory.listFiles();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (this.isIgnored(ignorePatternList, children[i])) continue;
            String filePath = this.normalizeUnicode(fileKeyPrefix + children[i].getName());
            if (children[i].isDirectory() && includeDirectories) {
                fileMap.put(filePath + Constants.FILE_PATH_DELIM, children[i]);
            } else if (!children[i].isDirectory()) {
                fileMap.put(filePath, children[i]);
            }
            if (!children[i].isDirectory()) continue;
            this.buildFileMapImpl(children[i], filePath + Constants.FILE_PATH_DELIM, fileMap, includeDirectories, ignorePatternList);
        }
    }

    public StorageObject[] listObjectsThreaded(StorageService service, final String bucketName, String targetPath, String delimiter, int toDepth) throws ServiceException {
        final List allObjects = Collections.synchronizedList(new ArrayList());
        final List lastCommonPrefixes = Collections.synchronizedList(new ArrayList());
        final ServiceException[] serviceExceptions = new ServiceException[1];
        final ThreadedStorageService threadedService = new ThreadedStorageService(service, new StorageServiceEventAdaptor(){

            public void event(ListObjectsEvent event) {
                if (3 == event.getEventCode()) {
                    for (StorageObjectsChunk chunk : event.getChunkList()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Listed " + chunk.getObjects().length + " objects and " + chunk.getCommonPrefixes().length + " common prefixes in bucket '" + bucketName + "' using prefix=" + chunk.getPrefix() + ", delimiter=" + chunk.getDelimiter()));
                        }
                        allObjects.addAll(Arrays.asList(chunk.getObjects()));
                        lastCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                    }
                } else if (0 == event.getEventCode()) {
                    serviceExceptions[0] = new ServiceException("Failed to list all objects in bucket", event.getErrorCause());
                }
            }
        });
        String[] prefixesToList = new String[]{targetPath};
        for (int currentDepth = 0; currentDepth <= toDepth && prefixesToList.length > 0; ++currentDepth) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Listing objects in '" + bucketName + "' using " + prefixesToList.length + " prefixes: " + Arrays.asList(prefixesToList)));
            }
            lastCommonPrefixes.clear();
            final String[] finalPrefixes = prefixesToList;
            final String finalDelimiter = currentDepth < toDepth ? delimiter : null;
            new Thread(){

                public void run() {
                    threadedService.listObjects(bucketName, finalPrefixes, finalDelimiter, 1000L);
                }
            }.run();
            if (serviceExceptions[0] != null) {
                throw serviceExceptions[0];
            }
            prefixesToList = lastCommonPrefixes.toArray(new String[lastCommonPrefixes.size()]);
        }
        return allObjects.toArray(new StorageObject[allObjects.size()]);
    }

    public StorageObject[] listObjectsThreaded(StorageService service, String bucketName, String targetPath) throws ServiceException {
        String delimiter = null;
        int toDepth = 0;
        String bucketListingProperties = this.jets3tProperties.getStringProperty("filecomparer.bucket-listing." + bucketName, null);
        if (bucketListingProperties != null) {
            String[] splits = bucketListingProperties.split(",");
            if (splits.length != 2) {
                throw new ServiceException("Invalid setting for bucket listing property filecomparer.bucket-listing." + bucketName + ": '" + bucketListingProperties + "'");
            }
            delimiter = splits[0].trim();
            toDepth = Integer.parseInt(splits[1]);
        }
        return this.listObjectsThreaded(service, bucketName, targetPath, delimiter, toDepth);
    }

    public Map<String, StorageObject> buildObjectMap(StorageService service, String bucketName, String targetPath, boolean skipMetadata, StorageServiceEventListener eventListener) throws ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        StorageObject[] objectsIncomplete = this.listObjectsThreaded(service, bucketName, prefix);
        return this.buildObjectMap(service, bucketName, targetPath, objectsIncomplete, skipMetadata, eventListener);
    }

    public PartialObjectListing buildObjectMapPartial(StorageService service, String bucketName, String targetPath, String priorLastKey, boolean completeListing, boolean skipMetadata, StorageServiceEventListener eventListener) throws ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        StorageObject[] objects = null;
        String resultPriorLastKey = null;
        if (completeListing) {
            objects = this.listObjectsThreaded(service, bucketName, prefix);
        } else {
            StorageObjectsChunk chunk = service.listObjectsChunked(bucketName, prefix, null, 1000L, priorLastKey, completeListing);
            objects = chunk.getObjects();
            resultPriorLastKey = chunk.getPriorLastKey();
        }
        Map<String, StorageObject> objectsMap = this.buildObjectMap(service, bucketName, targetPath, objects, skipMetadata, eventListener);
        return new PartialObjectListing(objectsMap, resultPriorLastKey);
    }

    public Map<String, StorageObject> buildObjectMap(StorageService service, String bucketName, String targetPath, StorageObject[] objectsIncomplete, boolean skipMetadata, StorageServiceEventListener eventListener) throws ServiceException {
        StorageObject[] objects = null;
        if (skipMetadata) {
            objects = objectsIncomplete;
        } else {
            final ArrayList objectsCompleteList = new ArrayList(objectsIncomplete.length);
            final ServiceException[] serviceExceptions = new ServiceException[1];
            ThreadedStorageService threadedService = new ThreadedStorageService(service, new StorageServiceEventAdaptor(){

                public void event(GetObjectHeadsEvent event) {
                    if (3 == event.getEventCode()) {
                        StorageObject[] finishedObjects = event.getCompletedObjects();
                        if (finishedObjects.length > 0) {
                            objectsCompleteList.addAll(Arrays.asList(finishedObjects));
                        }
                    } else if (0 == event.getEventCode()) {
                        serviceExceptions[0] = new ServiceException("Failed to retrieve detailed information about all objects", event.getErrorCause());
                    }
                }
            });
            if (eventListener != null) {
                threadedService.addServiceEventListener(eventListener);
            }
            threadedService.getObjectsHeads(bucketName, objectsIncomplete);
            if (serviceExceptions[0] != null) {
                throw serviceExceptions[0];
            }
            objects = objectsCompleteList.toArray(new StorageObject[objectsCompleteList.size()]);
        }
        return this.populateObjectMap(targetPath, objects);
    }

    public Map<String, StorageObject> populateObjectMap(String targetPath, StorageObject[] objects) {
        HashMap<String, StorageObject> map = new HashMap<String, StorageObject>();
        for (int i = 0; i < objects.length; ++i) {
            String relativeKey = objects[i].getKey();
            if (targetPath.length() > 0) {
                int slashIndex = (relativeKey = relativeKey.substring(targetPath.length())).indexOf(Constants.FILE_PATH_DELIM);
                relativeKey = slashIndex == 0 ? relativeKey.substring(slashIndex + 1, relativeKey.length()) : ((slashIndex = targetPath.lastIndexOf(Constants.FILE_PATH_DELIM)) >= 0 ? objects[i].getKey().substring(slashIndex + 1) : objects[i].getKey());
            }
            if (relativeKey.length() <= 0) continue;
            map.put(this.normalizeUnicode(relativeKey), objects[i]);
        }
        return map;
    }

    public FileComparerResults buildDiscrepancyLists(Map<String, File> filesMap, Map<String, StorageObject> objectsMap) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        return this.buildDiscrepancyLists(filesMap, objectsMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileComparerResults buildDiscrepancyLists(Map<String, File> filesMap, Map<String, StorageObject> objectsMap, BytesProgressWatcher progressWatcher) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        HashSet<String> onlyOnServerKeys = new HashSet<String>();
        HashSet<String> updatedOnServerKeys = new HashSet<String>();
        HashSet<String> updatedOnClientKeys = new HashSet<String>();
        HashSet<String> onlyOnClientKeys = new HashSet<String>();
        HashSet<String> alreadySynchronisedKeys = new HashSet<String>();
        HashSet<String> alreadySynchronisedLocalPaths = new HashSet<String>();
        boolean useMd5Files = this.jets3tProperties.getBoolProperty("filecomparer.use-md5-files", false);
        boolean generateMd5Files = this.jets3tProperties.getBoolProperty("filecomparer.generate-md5-files", false);
        boolean assumeLocalLatestInMismatch = this.jets3tProperties.getBoolProperty("filecomparer.assume-local-latest-in-mismatch", false);
        String md5FilesRootDirectoryPath = this.jets3tProperties.getStringProperty("filecomparer.md5-files-root-dir", null);
        File md5FilesRootDirectory = null;
        if (md5FilesRootDirectoryPath != null && !(md5FilesRootDirectory = new File(md5FilesRootDirectoryPath)).isDirectory()) {
            throw new FileNotFoundException("filecomparer.md5-files-root-dir path is not a directory: " + md5FilesRootDirectoryPath);
        }
        Iterator<Map.Entry<String, StorageObject>> objectsMapIter = objectsMap.entrySet().iterator();
        block8: while (true) {
            if (!objectsMapIter.hasNext()) {
                onlyOnClientKeys.addAll(filesMap.keySet());
                onlyOnClientKeys.removeAll(updatedOnClientKeys);
                onlyOnClientKeys.removeAll(updatedOnServerKeys);
                onlyOnClientKeys.removeAll(alreadySynchronisedKeys);
                onlyOnClientKeys.removeAll(alreadySynchronisedLocalPaths);
                return new FileComparerResults(onlyOnServerKeys, updatedOnServerKeys, updatedOnClientKeys, onlyOnClientKeys, alreadySynchronisedKeys, alreadySynchronisedLocalPaths);
            }
            Map.Entry<String, StorageObject> entry = objectsMapIter.next();
            String keyPath = entry.getKey();
            StorageObject storageObject = entry.getValue();
            Iterator<String> i$ = this.splitFilePathIntoDirPaths(keyPath, storageObject.isDirectoryPlaceholder()).iterator();
            while (true) {
                if (!i$.hasNext()) continue block8;
                String localPath = i$.next();
                if (filesMap.containsKey(localPath)) {
                    String string;
                    File file;
                    block38: {
                        File computedHashFile;
                        byte[] computedHash;
                        block37: {
                            file = filesMap.get(localPath);
                            if (file.isDirectory()) {
                                alreadySynchronisedKeys.add(keyPath);
                                alreadySynchronisedLocalPaths.add(localPath);
                                continue;
                            }
                            computedHash = null;
                            File file2 = computedHashFile = md5FilesRootDirectory != null ? new File(md5FilesRootDirectory, localPath + ".md5") : new File(file.getPath() + ".md5");
                            if (useMd5Files && computedHashFile.canRead() && computedHashFile.lastModified() > file.lastModified()) {
                                Object var27_37;
                                BufferedReader bufferedReader;
                                BufferedReader bufferedReader2 = null;
                                try {
                                    try {
                                        bufferedReader = new BufferedReader(new FileReader(computedHashFile));
                                        computedHash = ServiceUtils.fromHex(bufferedReader.readLine().split("\\s")[0]);
                                    }
                                    catch (Exception e) {
                                        if (log.isWarnEnabled()) {
                                            log.warn((Object)"Unable to read hash from computed MD5 file", (Throwable)e);
                                        }
                                        var27_37 = null;
                                        if (bufferedReader2 != null) {
                                            bufferedReader2.close();
                                        }
                                        break block37;
                                    }
                                    var27_37 = null;
                                    if (bufferedReader == null) break block37;
                                }
                                catch (Throwable throwable) {
                                    var27_37 = null;
                                    if (bufferedReader2 != null) {
                                        bufferedReader2.close();
                                    }
                                    throw throwable;
                                }
                                bufferedReader.close();
                            }
                        }
                        if (computedHash == null) {
                            void var24_31;
                            Object var24_28 = null;
                            if (progressWatcher != null) {
                                ProgressMonitoredInputStream progressMonitoredInputStream = new ProgressMonitoredInputStream(new FileInputStream(file), progressWatcher);
                            } else {
                                FileInputStream fileInputStream = new FileInputStream(file);
                            }
                            computedHash = ServiceUtils.computeMD5Hash((InputStream)var24_31);
                        }
                        string = ServiceUtils.toBase64(computedHash);
                        if (!(!generateMd5Files || file.getName().endsWith(".md5") || computedHashFile.exists() && computedHashFile.lastModified() >= file.lastModified())) {
                            Object var29_39;
                            File parentDir = computedHashFile.getParentFile();
                            if (parentDir != null && !parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            FileWriter fw = null;
                            try {
                                try {
                                    fw = new FileWriter(computedHashFile);
                                    fw.write(ServiceUtils.toHex(computedHash));
                                }
                                catch (Exception e) {
                                    if (log.isWarnEnabled()) {
                                        log.warn((Object)"Unable to write computed MD5 hash to a file", (Throwable)e);
                                    }
                                    var29_39 = null;
                                    if (fw != null) {
                                        fw.close();
                                    }
                                    break block38;
                                }
                                var29_39 = null;
                                if (fw == null) break block38;
                            }
                            catch (Throwable throwable) {
                                var29_39 = null;
                                if (fw != null) {
                                    fw.close();
                                }
                                throw throwable;
                            }
                            fw.close();
                        }
                    }
                    String objectHash = null;
                    if (storageObject.containsMetadata("original-md5-hash")) {
                        objectHash = (String)storageObject.getMetadata("original-md5-hash");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Object in service is encoded, using the object's original hash value for: " + storageObject.getKey()));
                        }
                    } else {
                        objectHash = storageObject.getMd5HashAsBase64();
                    }
                    if (string.equals(objectHash)) {
                        alreadySynchronisedKeys.add(keyPath);
                        alreadySynchronisedLocalPaths.add(localPath);
                        continue;
                    }
                    Date objectLastModified = null;
                    String metadataLocalFileDate = (String)storageObject.getMetadata("jets3t-original-file-date-iso8601");
                    if (metadataLocalFileDate == null) {
                        if (!assumeLocalLatestInMismatch && log.isWarnEnabled()) {
                            log.warn((Object)"Using service last modified date as file date. This is not reliable as the time according to service can differ from your local system time. Please use the metadata item jets3t-original-file-date-iso8601");
                        }
                        objectLastModified = storageObject.getLastModifiedDate();
                    } else {
                        objectLastModified = ServiceUtils.parseIso8601Date(metadataLocalFileDate);
                    }
                    if (objectLastModified.getTime() > file.lastModified()) {
                        updatedOnServerKeys.add(keyPath);
                        continue;
                    }
                    if (objectLastModified.getTime() < file.lastModified()) {
                        updatedOnClientKeys.add(keyPath);
                        continue;
                    }
                    if (!assumeLocalLatestInMismatch) {
                        throw new IOException("Backed-up object " + storageObject.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "This shouldn't happen!");
                    }
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Backed-up object " + storageObject.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "Assuming local file is the latest version."));
                    }
                    updatedOnClientKeys.add(keyPath);
                    continue;
                }
                onlyOnServerKeys.add(keyPath);
            }
            break;
        }
    }

    private Set<String> splitFilePathIntoDirPaths(String path, boolean isDirectoryPlaceholder) {
        HashSet<String> dirPathsSet = new HashSet<String>();
        String[] pathComponents = path.split(Constants.FILE_PATH_DELIM);
        String myPath = "";
        for (int i = 0; i < pathComponents.length; ++i) {
            String pathComponent = pathComponents[i];
            myPath = myPath + pathComponent;
            if (i < pathComponents.length - 1 || isDirectoryPlaceholder) {
                myPath = myPath + Constants.FILE_PATH_DELIM;
            }
            dirPathsSet.add(myPath);
        }
        return dirPathsSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartialObjectListing {
        private Map<String, StorageObject> objectsMap = null;
        private String priorLastKey = null;

        public PartialObjectListing(Map<String, StorageObject> objectsMap, String priorLastKey) {
            this.objectsMap = objectsMap;
            this.priorLastKey = priorLastKey;
        }

        public Map<String, StorageObject> getObjectsMap() {
            return this.objectsMap;
        }

        public String getPriorLastKey() {
            return this.priorLastKey;
        }
    }
}

