/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.management.GuardInvocationHandler;
import org.apache.activemq.artemis.core.server.management.HawtioSecurityControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioSecurityControlImpl
extends AbstractControl
implements HawtioSecurityControl {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final TabularType CAN_INVOKE_TABULAR_TYPE = SecurityMBeanOpenTypeInitializer.TABULAR_TYPE;
    static final CompositeType CAN_INVOKE_RESULT_ROW_TYPE = SecurityMBeanOpenTypeInitializer.ROW_TYPE;
    static final String[] CAN_INVOKE_RESULT_COLUMNS = SecurityMBeanOpenTypeInitializer.COLUMNS;
    private final GuardInvocationHandler mBeanServerGuard;

    public HawtioSecurityControlImpl(GuardInvocationHandler mBeanServerGuard, StorageManager storageManager) throws NotCompliantMBeanException {
        super(HawtioSecurityControl.class, storageManager);
        this.mBeanServerGuard = mBeanServerGuard;
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(HawtioSecurityControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(HawtioSecurityControl.class);
    }

    @Override
    public boolean canInvoke(String objectName) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, null);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, methodName);
    }

    @Override
    public boolean canInvoke(String objectName, String methodName, String[] argumentTypes) throws Exception {
        return this.mBeanServerGuard == null || this.mBeanServerGuard.canInvoke(objectName, methodName);
    }

    @Override
    public TabularData canInvoke(Map<String, List<String>> bulkQuery) throws Exception {
        TabularDataSupport table = new TabularDataSupport(CAN_INVOKE_TABULAR_TYPE);
        for (Map.Entry<String, List<String>> entry : bulkQuery.entrySet()) {
            String objectName = entry.getKey();
            List<String> methods = entry.getValue();
            if (methods.isEmpty()) {
                boolean res = this.canInvoke(objectName);
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, "", res});
                table.put(data);
                continue;
            }
            for (String method : methods) {
                ArrayList<String> argTypes;
                String name = this.parseMethodName(method, argTypes = new ArrayList<String>());
                boolean res = name.equals(method) ? this.canInvoke(objectName, name) : this.canInvoke(objectName, name, argTypes.toArray(new String[0]));
                CompositeDataSupport data = new CompositeDataSupport(CAN_INVOKE_RESULT_ROW_TYPE, CAN_INVOKE_RESULT_COLUMNS, new Object[]{objectName, method, res});
                try {
                    table.put(data);
                }
                catch (KeyAlreadyExistsException e) {
                    logger.debug("Key already exists: {} (objectName = \"{}\", method = \"{}\")", new Object[]{e.getMessage(), objectName, method});
                }
            }
        }
        return table;
    }

    private String parseMethodName(String method, List<String> argTypes) {
        int index = (method = method.trim()).indexOf(40);
        if (index < 0) {
            return method;
        }
        String args = method.substring(index + 1, method.length() - 1);
        argTypes.addAll(Arrays.asList(args.split(",")));
        return method.substring(0, index);
    }

    static class SecurityMBeanOpenTypeInitializer {
        private static final String[] COLUMNS = new String[]{"ObjectName", "Method", "CanInvoke"};
        private static final CompositeType ROW_TYPE;
        private static final TabularType TABULAR_TYPE;

        SecurityMBeanOpenTypeInitializer() {
        }

        static {
            try {
                ROW_TYPE = new CompositeType("CanInvokeRowType", "The rows of a CanInvokeTabularType table.", COLUMNS, new String[]{"The ObjectName of the MBean checked", "The Method to checked. This can either be a bare method name which means 'any method with this name' or a specific overload such as foo(java.lang.String). If an empty String is returned this means 'any' method.", "true if the method or mbean can potentially be invoked by the current user."}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN});
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
            try {
                TABULAR_TYPE = new TabularType("CanInvokeTabularType", "Result of canInvoke() bulk operation", ROW_TYPE, new String[]{"ObjectName", "Method"});
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

