/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.stream;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private final InputStream delegate;
    private int count = 0;

    public CountingInputStream(InputStream rawIn) {
        this.delegate = rawIn;
    }

    @Override
    public int read() throws IOException {
        int r = this.delegate.read();
        if (r == -1) {
            return -1;
        }
        ++this.count;
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int read = this.delegate.read(b);
        this.count += read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.delegate.read(b, off, len);
        this.count += read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.delegate.skip(n);
        this.count = (int)((long)this.count + skip);
        return skip;
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    public int getCount() {
        return this.count;
    }
}

