/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.provider.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingContext;
import org.opensaml.xacml.ctx.provider.impl.ObligationProcessingException;
import org.opensaml.xacml.policy.ObligationType;

public abstract class BaseObligationHandler {
    @Nonnull
    @NotEmpty
    private String id;
    private int precedence;

    protected BaseObligationHandler(@Nonnull @NotEmpty String obligationId) {
        this(obligationId, Integer.MIN_VALUE);
    }

    protected BaseObligationHandler(@Nonnull @NotEmpty String obligationId, int handlerPrecedence) {
        this.id = StringSupport.trimOrNull((String)obligationId);
        if (this.id == null) {
            throw new IllegalArgumentException("Provided obligation ID may not be null or empty");
        }
        this.precedence = handlerPrecedence;
    }

    @Nonnull
    @NotEmpty
    public String getObligationId() {
        return this.id;
    }

    public int getHandlerPrecedence() {
        return this.precedence;
    }

    public abstract void evaluateObligation(@Nonnull ObligationProcessingContext var1, @Nonnull ObligationType var2) throws ObligationProcessingException;

    public int hashCode() {
        return this.getObligationId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BaseObligationHandler) {
            return Objects.equals(this.getObligationId(), ((BaseObligationHandler)obj).getObligationId());
        }
        return false;
    }
}

