/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse.client;

import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.sse.InboundSseEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.OptionalLong;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.message.Message;

public final class InboundSseEventImpl
implements InboundSseEvent {
    private final String id;
    private final String name;
    private final String comment;
    private final long reconnectDelay;
    private final boolean reconnectDelaySet;
    private final String data;
    private final ClientProviderFactory factory;
    private final Message message;

    InboundSseEventImpl(String id, String name, String comment, long reconnectDelay, boolean reconnectDelaySet, String data, ClientProviderFactory factory, Message message) {
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.reconnectDelay = reconnectDelay;
        this.reconnectDelaySet = reconnectDelaySet;
        this.data = data;
        this.factory = factory;
        this.message = message;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public boolean isReconnectDelaySet() {
        return this.reconnectDelaySet;
    }

    public boolean isEmpty() {
        return false;
    }

    public String readData() {
        return this.data;
    }

    public <T> T readData(Class<T> type) {
        return this.read(type, type, MediaType.TEXT_PLAIN_TYPE);
    }

    public <T> T readData(GenericType<T> type) {
        return this.read(type.getRawType(), type.getType(), MediaType.TEXT_PLAIN_TYPE);
    }

    public <T> T readData(Class<T> messageType, MediaType mediaType) {
        return this.read(messageType, messageType, mediaType);
    }

    public <T> T readData(GenericType<T> type, MediaType mediaType) {
        return this.read(type.getRawType(), type.getType(), mediaType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T read(Class<T> messageType, Type type, MediaType mediaType) {
        if (this.data == null) {
            return null;
        }
        Annotation[] annotations = new Annotation[]{};
        MultivaluedHashMap headers = new MultivaluedHashMap(0);
        MessageBodyReader reader = this.factory.createMessageBodyReader(messageType, type, annotations, mediaType, this.message);
        if (reader == null) {
            throw new RuntimeException("No suitable message body reader for class: " + messageType.getName());
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(this.data.getBytes(StandardCharsets.UTF_8));){
            Object object = reader.readFrom(messageType, type, annotations, mediaType, (MultivaluedMap)headers, (InputStream)is);
            return (T)object;
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to read data of type " + messageType.getName(), ex);
        }
    }

    static class Builder {
        private static final Logger LOG = LogUtils.getL7dLogger(Builder.class);
        private String name;
        private String id;
        private String comment;
        private OptionalLong reconnectDelay = OptionalLong.empty();
        private String data;

        Builder() {
        }

        Builder id(String i) {
            this.id = i;
            return this;
        }

        Builder name(String n) {
            this.name = n;
            return this;
        }

        Builder comment(String cmt) {
            this.comment = cmt;
            return this;
        }

        Builder reconnectDelay(String rd) {
            try {
                this.reconnectDelay = OptionalLong.of(Long.parseLong(rd));
            }
            catch (NumberFormatException ex) {
                LOG.warning("Unable to parse reconnectDelay, long number expected: " + ex.getMessage());
            }
            return this;
        }

        Builder appendData(String d) {
            this.data = this.data == null ? d : this.data + "\n" + d;
            return this;
        }

        InboundSseEvent build(ClientProviderFactory factory, Message message) {
            return new InboundSseEventImpl(this.id, this.name, this.comment, this.reconnectDelay.orElse(-1L), this.reconnectDelay.isPresent(), this.data, factory, message);
        }
    }
}

