/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.OperationImpl;
import io.smallrye.openapi.runtime.io.ExternalDocumentationIO;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.callbacks.CallbackIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.parameters.ParameterIO;
import io.smallrye.openapi.runtime.io.parameters.RequestBodyIO;
import io.smallrye.openapi.runtime.io.responses.APIResponsesIO;
import io.smallrye.openapi.runtime.io.security.SecurityRequirementIO;
import io.smallrye.openapi.runtime.io.servers.ServerIO;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class OperationIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Operation, V, A, O, AB, OB> {
    protected static final String PROP_OPERATION_ID = "operationId";
    protected static final String PROP_TAGS = "tags";
    protected static final String PROP_DESCRIPTION = "description";
    protected static final String PROP_SECURITY = "security";
    protected static final String PROP_SECURITY_SETS = "securitySets";
    protected static final String PROP_REQUEST_BODY = "requestBody";
    protected static final String PROP_PARAMETERS = "parameters";
    protected static final String PROP_SERVERS = "servers";
    protected static final String PROP_SUMMARY = "summary";
    protected static final String PROP_DEPRECATED = "deprecated";
    protected static final String PROP_CALLBACKS = "callbacks";
    protected static final String PROP_HIDDEN = "hidden";
    protected static final String PROP_RESPONSES = "responses";
    protected static final String PROP_EXTERNAL_DOCS = "externalDocs";
    protected final APIResponsesIO<V, A, O, AB, OB> responsesIO;
    private final CallbackIO<V, A, O, AB, OB> callbackIO;
    private final ServerIO<V, A, O, AB, OB> serverIO;
    protected final ExternalDocumentationIO<V, A, O, AB, OB> externalDocIO;
    private final ParameterIO<V, A, O, AB, OB> parameterIO;
    private final RequestBodyIO<V, A, O, AB, OB> requestBodyIO;
    private final SecurityRequirementIO<V, A, O, AB, OB> securityRequirementIO;
    protected final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public OperationIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, CallbackIO<V, A, O, AB, OB> callbackIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        this(context, Names.OPERATION, contentIO, callbackIO, extensionIO);
    }

    public OperationIO(IOContext<V, A, O, AB, OB> context, DotName annotationName, ContentIO<V, A, O, AB, OB> contentIO, CallbackIO<V, A, O, AB, OB> callbackIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, annotationName, Names.create(Operation.class));
        this.responsesIO = new APIResponsesIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.callbackIO = callbackIO != null ? callbackIO : new CallbackIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.serverIO = new ServerIO<V, A, O, AB, OB>(context, extensionIO);
        this.externalDocIO = new ExternalDocumentationIO<V, A, O, AB, OB>(context, extensionIO);
        this.parameterIO = new ParameterIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.requestBodyIO = new RequestBodyIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.securityRequirementIO = new SecurityRequirementIO<V, A, O, AB, OB>(context);
        this.extensionIO = extensionIO;
    }

    public OperationIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        this(context, contentIO, null, extensionIO);
    }

    public boolean isHidden(AnnotationTarget target) {
        return Optional.ofNullable(this.getAnnotation(target)).map(annotation -> (Boolean)this.value((AnnotationInstance)annotation, PROP_HIDDEN)).orElse(false);
    }

    @Override
    public Operation read(AnnotationInstance annotationInstance) {
        IoLogging.logger.singleAnnotation("@Operation");
        OperationImpl operation = new OperationImpl();
        operation.setSummary((String)this.value(annotationInstance, PROP_SUMMARY));
        operation.setDescription((String)this.value(annotationInstance, PROP_DESCRIPTION));
        operation.setOperationId((String)this.value(annotationInstance, PROP_OPERATION_ID));
        operation.setDeprecated((Boolean)this.value(annotationInstance, PROP_DEPRECATED));
        operation.setExtensions(this.extensionIO.readExtensible(annotationInstance));
        return operation;
    }

    @Override
    public Operation readObject(O node) {
        IoLogging.logger.singleJsonObject("Operation");
        OperationImpl model = new OperationImpl();
        model.setTags(this.jsonIO().getArray(node, PROP_TAGS, this.jsonIO()::asString).orElse(null));
        model.setSummary(this.jsonIO().getString(node, PROP_SUMMARY));
        model.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        model.setExternalDocs((ExternalDocumentation)this.externalDocIO.readValue(this.jsonIO().getValue(node, PROP_EXTERNAL_DOCS)));
        model.setOperationId(this.jsonIO().getString(node, PROP_OPERATION_ID));
        model.setParameters(this.parameterIO.readList(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        model.setRequestBody((RequestBody)this.requestBodyIO.readValue(this.jsonIO().getValue(node, PROP_REQUEST_BODY)));
        model.setResponses((APIResponses)this.responsesIO.readValue(this.jsonIO().getValue(node, PROP_RESPONSES)));
        model.setCallbacks(this.callbackIO.readMap(this.jsonIO().getValue(node, PROP_CALLBACKS)));
        model.setDeprecated(this.jsonIO().getBoolean(node, PROP_DEPRECATED));
        model.setSecurity(this.securityRequirementIO.readList(this.jsonIO().getValue(node, PROP_SECURITY)));
        model.setServers(this.serverIO.readList(this.jsonIO().getValue(node, PROP_SERVERS)));
        this.extensionIO.readMap(node).forEach((arg_0, arg_1) -> ((Operation)model).addExtension(arg_0, arg_1));
        return model;
    }

    @Override
    public Optional<O> write(Operation model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_TAGS, this.jsonIO().toJson(model.getTags()));
            this.setIfPresent(node, PROP_SUMMARY, this.jsonIO().toJson(model.getSummary()));
            this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
            this.setIfPresent(node, PROP_EXTERNAL_DOCS, this.externalDocIO.write(model.getExternalDocs()));
            this.setIfPresent(node, PROP_OPERATION_ID, this.jsonIO().toJson(model.getOperationId()));
            this.setIfPresent(node, PROP_PARAMETERS, this.parameterIO.write(model.getParameters()));
            this.setIfPresent(node, PROP_REQUEST_BODY, this.requestBodyIO.write(model.getRequestBody()));
            this.setIfPresent(node, PROP_RESPONSES, this.responsesIO.write(model.getResponses()));
            this.setIfPresent(node, PROP_CALLBACKS, this.callbackIO.write(model.getCallbacks()));
            this.setIfPresent(node, PROP_DEPRECATED, this.jsonIO().toJson(model.getDeprecated()));
            this.setIfPresent(node, PROP_SECURITY, this.securityRequirementIO.write(model.getSecurity()));
            this.setIfPresent(node, PROP_SERVERS, this.serverIO.write(model.getServers()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

