/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import java.util.Optional;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.token.cipher.JwtTicketCipherExecutor;
import org.apereo.cas.token.cipher.RegisteredServiceJwtTicketCipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;

public class OAuth20RegisteredServiceJwtAccessTokenCipherExecutor
extends RegisteredServiceJwtTicketCipherExecutor {
    protected RegisteredServiceProperty.RegisteredServiceProperties getSigningKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionKeyRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_KEY;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getEncryptionAlgRegisteredServiceProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ALG;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherStrategyTypeRegisteredServiceProperty(RegisteredService registeredService) {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_CIPHER_STRATEGY_TYPE;
    }

    public Optional<String> getSigningKey(RegisteredService registeredService) {
        if (this.isSigningEnabledForRegisteredService(registeredService)) {
            return super.getSigningKey(registeredService);
        }
        return Optional.empty();
    }

    protected boolean isEncryptionEnabledForRegisteredService(RegisteredService registeredService) {
        return super.isEncryptionEnabledForRegisteredService(registeredService);
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceSigningEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_SIGNING_ENABLED;
    }

    protected RegisteredServiceProperty.RegisteredServiceProperties getCipherOperationRegisteredServiceEncryptionEnabledProperty() {
        return RegisteredServiceProperty.RegisteredServiceProperties.ACCESS_TOKEN_AS_JWT_ENCRYPTION_ENABLED;
    }

    public Optional<String> getEncryptionKey(RegisteredService registeredService) {
        if (this.isEncryptionEnabledForRegisteredService(registeredService)) {
            return super.getEncryptionKey(registeredService);
        }
        return Optional.empty();
    }

    protected JwtTicketCipherExecutor createCipherExecutorInstance(String encryptionKey, String signingKey, RegisteredService registeredService) {
        JwtTicketCipherExecutor cipher = super.createCipherExecutorInstance(encryptionKey, signingKey, registeredService);
        return this.prepareCipherExecutor(cipher, registeredService);
    }

    protected JwtTicketCipherExecutor prepareCipherExecutor(JwtTicketCipherExecutor cipher, RegisteredService registeredService) {
        if (registeredService instanceof OAuthRegisteredService) {
            OAuthRegisteredService oauthRegisteredService = (OAuthRegisteredService)registeredService;
            FunctionUtils.doIfNotBlank((CharSequence)oauthRegisteredService.getJwtAccessTokenSigningAlg(), arg_0 -> ((JwtTicketCipherExecutor)cipher).setSigningAlgorithm(arg_0));
        }
        return cipher;
    }
}

