/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.revocation.policy;

import java.security.cert.X509CRL;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.adaptors.x509.authentication.ExpiredCRLException;
import org.apereo.cas.adaptors.x509.authentication.revocation.policy.RevocationPolicy;
import org.apereo.cas.util.crypto.CertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdExpiredCRLRevocationPolicy
implements RevocationPolicy<X509CRL> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ThresholdExpiredCRLRevocationPolicy.class);
    private final int threshold;

    @Override
    public void apply(X509CRL crl) throws ExpiredCRLException {
        ZonedDateTime cutoff = ZonedDateTime.now(ZoneOffset.UTC);
        if (CertUtils.isExpired((X509CRL)crl, (ZonedDateTime)cutoff)) {
            if (CertUtils.isExpired((X509CRL)crl, (ZonedDateTime)cutoff.minusSeconds(this.threshold))) {
                throw new ExpiredCRLException(crl.toString(), cutoff, this.threshold);
            }
            LOGGER.info("CRL expired on [{}] but is within threshold period, [{}] seconds.", (Object)crl.getNextUpdate(), (Object)this.threshold);
        }
    }

    @Generated
    public ThresholdExpiredCRLRevocationPolicy(int threshold) {
        this.threshold = threshold;
    }
}

