/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.rest.cxf.service;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.service.AuthProfileService;
import org.apache.syncope.core.logic.AuthProfileLogic;
import org.apache.syncope.core.rest.cxf.service.AbstractService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class AuthProfileServiceImpl
extends AbstractService
implements AuthProfileService {
    protected final AuthProfileLogic logic;

    public AuthProfileServiceImpl(AuthProfileLogic logic) {
        this.logic = logic;
    }

    public PagedResult<AuthProfileTO> list(int page, int size) {
        Page result = this.logic.list((Pageable)PageRequest.of((int)(page < 1 ? 0 : page - 1), (int)(size < 1 ? 1 : size)));
        return this.buildPagedResult(result);
    }

    public AuthProfileTO read(String key) {
        return this.logic.read(key);
    }

    public Response create(AuthProfileTO authProfileTO) {
        AuthProfileTO created = this.logic.create(authProfileTO);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void update(AuthProfileTO authProfileTO) {
        this.logic.update(authProfileTO);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

