/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.ApiException;
import org.apache.syncope.ext.openfga.client.ApiResponse;
import org.apache.syncope.ext.openfga.client.Configuration;
import org.apache.syncope.ext.openfga.client.Pair;
import org.apache.syncope.ext.openfga.client.model.ReadChangesResponse;
import org.apache.syncope.ext.openfga.client.model.ReadRequest;
import org.apache.syncope.ext.openfga.client.model.ReadResponse;
import org.apache.syncope.ext.openfga.client.model.WriteRequest;

public class RelationshipTuplesApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<InputStream>> memberVarAsyncResponseInterceptor;

    public RelationshipTuplesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RelationshipTuplesApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = null;
        try (InputStream responseBody = ApiClient.getResponseBody(response);){
            body = responseBody == null ? null : new String(responseBody.readAllBytes());
        }
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public File downloadFileFromResponse(HttpResponse<InputStream> response, InputStream responseBody) throws ApiException {
        if (responseBody == null) {
            throw new ApiException(new IOException("Response body is empty"));
        }
        try {
            File file = this.prepareDownloadFile(response);
            Files.copy(responseBody, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return file;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private File prepareDownloadFile(HttpResponse<InputStream> response) throws IOException {
        Pattern pattern;
        Matcher matcher;
        String filename = null;
        Optional<String> contentDisposition = response.headers().firstValue("Content-Disposition");
        if (contentDisposition.isPresent() && !"".equals(contentDisposition.get()) && (matcher = (pattern = Pattern.compile("filename=['\"]?([^'\"\\s]+)['\"]?")).matcher(contentDisposition.get())).find()) {
            filename = matcher.group(1);
        }
        File file = null;
        if (filename != null) {
            Path tempDir = Files.createTempDirectory("swagger-gen-native", new FileAttribute[0]);
            Path filePath = Files.createFile(tempDir.resolve(filename), new FileAttribute[0]);
            file = filePath.toFile();
            tempDir.toFile().deleteOnExit();
            file.deleteOnExit();
        } else {
            file = Files.createTempFile("download-", "", new FileAttribute[0]).toFile();
            file.deleteOnExit();
        }
        return file;
    }

    public ReadResponse read(@Nonnull String storeId, @Nonnull ReadRequest body) throws ApiException {
        return this.read(storeId, body, null);
    }

    public ReadResponse read(@Nonnull String storeId, @Nonnull ReadRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<ReadResponse> localVarResponse = this.readWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadResponse> readWithHttpInfo(@Nonnull String storeId, @Nonnull ReadRequest body) throws ApiException {
        return this.readWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ReadResponse> readWithHttpInfo(@Nonnull String storeId, @Nonnull ReadRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("read", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ReadResponse responseValue = responseBody.isBlank() ? null : (ReadResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadResponse>(this){});
                ApiResponse<ReadResponse> apiResponse = new ApiResponse<ReadResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readRequestBuilder(@Nonnull String storeId, @Nonnull ReadRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling read");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling read");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/read".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public ReadChangesResponse readChanges(@Nonnull String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken, @Nullable OffsetDateTime startTime) throws ApiException {
        return this.readChanges(storeId, type, pageSize, continuationToken, startTime, null);
    }

    public ReadChangesResponse readChanges(@Nonnull String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken, @Nullable OffsetDateTime startTime, Map<String, String> headers) throws ApiException {
        ApiResponse<ReadChangesResponse> localVarResponse = this.readChangesWithHttpInfo(storeId, type, pageSize, continuationToken, startTime, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<ReadChangesResponse> readChangesWithHttpInfo(@Nonnull String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken, @Nullable OffsetDateTime startTime) throws ApiException {
        return this.readChangesWithHttpInfo(storeId, type, pageSize, continuationToken, startTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<ReadChangesResponse> readChangesWithHttpInfo(@Nonnull String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken, @Nullable OffsetDateTime startTime, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.readChangesRequestBuilder(storeId, type, pageSize, continuationToken, startTime, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("readChanges", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                ReadChangesResponse responseValue = responseBody.isBlank() ? null : (ReadChangesResponse)this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<ReadChangesResponse>(this){});
                ApiResponse<ReadChangesResponse> apiResponse = new ApiResponse<ReadChangesResponse>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder readChangesRequestBuilder(@Nonnull String storeId, @Nullable String type, @Nullable Integer pageSize, @Nullable String continuationToken, @Nullable OffsetDateTime startTime, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling readChanges");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/changes".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName = "type";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("type", type));
        localVarQueryParameterBaseName = "page_size";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("page_size", pageSize));
        localVarQueryParameterBaseName = "continuation_token";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("continuation_token", continuationToken));
        localVarQueryParameterBaseName = "start_time";
        localVarQueryParams.addAll(ApiClient.parameterToPairs("start_time", startTime));
        if (!localVarQueryParams.isEmpty() || localVarQueryStringJoiner.length() != 0) {
            StringJoiner queryJoiner = new StringJoiner("&");
            localVarQueryParams.forEach(p -> queryJoiner.add(p.getName() + "=" + p.getValue()));
            if (localVarQueryStringJoiner.length() != 0) {
                queryJoiner.add(localVarQueryStringJoiner.toString());
            }
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath + "?" + queryJoiner.toString()));
        } else {
            localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        }
        localVarRequestBuilder.header("Accept", "application/json");
        localVarRequestBuilder.method("GET", HttpRequest.BodyPublishers.noBody());
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public Object write(@Nonnull String storeId, @Nonnull WriteRequest body) throws ApiException {
        return this.write(storeId, body, null);
    }

    public Object write(@Nonnull String storeId, @Nonnull WriteRequest body, Map<String, String> headers) throws ApiException {
        ApiResponse<Object> localVarResponse = this.writeWithHttpInfo(storeId, body, headers);
        return localVarResponse.getData();
    }

    public ApiResponse<Object> writeWithHttpInfo(@Nonnull String storeId, @Nonnull WriteRequest body) throws ApiException {
        return this.writeWithHttpInfo(storeId, body, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResponse<Object> writeWithHttpInfo(@Nonnull String storeId, @Nonnull WriteRequest body, Map<String, String> headers) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.writeRequestBuilder(storeId, body, headers);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            try (InputStream localVarResponseBody = null;){
                if (localVarResponse.statusCode() / 100 != 2) {
                    throw this.getApiException("write", localVarResponse);
                }
                localVarResponseBody = ApiClient.getResponseBody(localVarResponse);
                if (localVarResponseBody == null) {
                    ApiResponse<Object> apiResponse2 = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
                    return apiResponse2;
                }
                String responseBody = new String(localVarResponseBody.readAllBytes());
                Object responseValue = responseBody.isBlank() ? null : this.memberVarObjectMapper.readValue(responseBody, (TypeReference)new TypeReference<Object>(this){});
                ApiResponse<Object> apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), responseValue);
                return apiResponse;
            }
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiException(e);
        }
    }

    private HttpRequest.Builder writeRequestBuilder(@Nonnull String storeId, @Nonnull WriteRequest body, Map<String, String> headers) throws ApiException {
        if (storeId == null) {
            throw new ApiException(400, "Missing the required parameter 'storeId' when calling write");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling write");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/stores/{store_id}/write".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "application/json");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes((Object)body);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        localVarRequestBuilder = HttpRequestBuilderExtensions.withAdditionalHeaders(localVarRequestBuilder, headers);
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    private static class HttpRequestBuilderExtensions {
        private HttpRequestBuilderExtensions() {
        }

        static HttpRequest.Builder withAdditionalHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    builder.header(entry.getKey(), entry.getValue());
                }
            }
            return builder;
        }
    }
}

