/*
 * Decompiled with CFR 0.152.
 */
package retrofit2.converter.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import java.io.IOException;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.ByteString;
import retrofit2.Converter;

final class MoshiResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private static final ByteString UTF8_BOM = ByteString.decodeHex((String)"EFBBBF");
    private final JsonAdapter<T> adapter;

    MoshiResponseBodyConverter(JsonAdapter<T> adapter) {
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T convert(ResponseBody value) throws IOException {
        BufferedSource source = value.source();
        try {
            if (source.rangeEquals(0L, UTF8_BOM)) {
                source.skip((long)UTF8_BOM.size());
            }
            JsonReader reader = JsonReader.of((BufferedSource)source);
            Object result = this.adapter.fromJson(reader);
            if (reader.peek() != JsonReader.Token.END_DOCUMENT) {
                throw new JsonDataException("JSON document was not fully consumed.");
            }
            Object object = result;
            return (T)object;
        }
        finally {
            value.close();
        }
    }
}

